/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.street_notes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.services.notes.DynamicStreetNotesSource;
import org.opentripplanner.routing.services.notes.MatcherAndStreetNote;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.street_notes.WFSNotePollingGraphUpdaterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WFSNotePollingGraphUpdater
extends PollingGraphUpdater {
    protected Graph graph;
    private WriteToGraphCallback saveResultOnGraph;
    private SetMultimap<Edge, MatcherAndStreetNote> notesForEdge;
    private Map<T2<NoteMatcher, StreetNote>, MatcherAndStreetNote> uniqueMatchers;
    private URL url;
    private String featureType;
    private Query query;
    private FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    private final DynamicStreetNotesSource notesSource = new DynamicStreetNotesSource();
    private static final double SEARCH_RADIUS_M = 1.0;
    private static final double SEARCH_RADIUS_DEG = SphericalDistanceLibrary.metersToDegrees(1.0);
    private static final NoteMatcher NOTE_MATCHER = StreetNotesService.ALWAYS_MATCHER;
    private static final Logger LOG = LoggerFactory.getLogger(WFSNotePollingGraphUpdater.class);

    public WFSNotePollingGraphUpdater(WFSNotePollingGraphUpdaterParameters config) {
        super(config);
        try {
            this.url = new URL(config.getUrl());
            this.featureType = config.getFeatureType();
            LOG.info("Configured WFS polling updater: frequencySec={}, url={} and featureType={}", new Object[]{this.pollingPeriodSeconds, this.url.toString(), this.featureType});
        }
        catch (MalformedURLException e) {
            LOG.warn(e.toString());
        }
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) throws IOException, FactoryException {
        this.graph = graph;
        LOG.info("Setup WFS polling updater");
        HashMap<String, URL> connectionParameters = new HashMap<String, URL>();
        connectionParameters.put(WFSDataStoreFactory.URL.key, this.url);
        WFSDataStore data = new WFSDataStoreFactory().createDataStore(connectionParameters);
        this.query = new Query(this.featureType);
        this.query.setCoordinateSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
        this.featureSource = data.getFeatureSource(this.featureType);
        graph.streetNotesService.addNotesSource(this.notesSource);
    }

    @Override
    public void teardown() {
        LOG.info("Teardown WFS polling updater");
    }

    @Override
    protected void runPolling() throws IOException {
        LOG.info("Run WFS polling updater with hashcode: {}", (Object)this.hashCode());
        this.notesForEdge = HashMultimap.create();
        this.uniqueMatchers = new HashMap<T2<NoteMatcher, StreetNote>, MatcherAndStreetNote>();
        FeatureIterator features = this.featureSource.getFeatures(this.query).features();
        while (features.hasNext()) {
            StreetNote streetNote;
            SimpleFeature feature = (SimpleFeature)features.next();
            if (feature.getDefaultGeometry() == null || (streetNote = this.getNote(feature)) == null) continue;
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            Geometry searchArea = geom.buffer(SEARCH_RADIUS_DEG);
            Collection<Edge> edges = this.graph.getStreetIndex().getEdgesForEnvelope(searchArea.getEnvelopeInternal());
            for (Edge edge : edges) {
                if (!(edge instanceof StreetEdge) || searchArea.disjoint((Geometry)edge.getGeometry())) continue;
                this.addNote(edge, streetNote, NOTE_MATCHER);
            }
        }
        this.saveResultOnGraph.execute(new WFSGraphWriter());
    }

    protected abstract StreetNote getNote(SimpleFeature var1);

    private void addNote(Edge edge, StreetNote note, NoteMatcher matcher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding note {} to {} with matcher {}", new Object[]{note, edge, matcher});
        }
        this.notesForEdge.put((Object)edge, (Object)this.buildMatcherAndStreetNote(matcher, note));
    }

    private MatcherAndStreetNote buildMatcherAndStreetNote(NoteMatcher noteMatcher, StreetNote note) {
        T2<NoteMatcher, StreetNote> key = new T2<NoteMatcher, StreetNote>(noteMatcher, note);
        MatcherAndStreetNote interned = this.uniqueMatchers.get(key);
        if (interned != null) {
            return interned;
        }
        MatcherAndStreetNote ret = new MatcherAndStreetNote(noteMatcher, note);
        this.uniqueMatchers.put(key, ret);
        return ret;
    }

    private class WFSGraphWriter
    implements GraphWriterRunnable {
        private WFSGraphWriter() {
        }

        @Override
        public void run(Graph graph) {
            WFSNotePollingGraphUpdater.this.notesSource.setNotes(WFSNotePollingGraphUpdater.this.notesForEdge);
        }
    }
}

