/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.stoptime;

import com.google.common.base.Preconditions;
import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.stoptime.TimetableSnapshotSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripUpdateGraphWriterRunnable
implements GraphWriterRunnable {
    private static Logger LOG = LoggerFactory.getLogger(TripUpdateGraphWriterRunnable.class);
    private final boolean fullDataset;
    private final List<GtfsRealtime.TripUpdate> updates;
    private final String feedId;

    TripUpdateGraphWriterRunnable(boolean fullDataset, List<GtfsRealtime.TripUpdate> updates, String feedId) {
        Preconditions.checkNotNull(updates);
        Preconditions.checkNotNull((Object)feedId);
        this.fullDataset = fullDataset;
        this.updates = updates;
        this.feedId = feedId;
    }

    @Override
    public void run(Graph graph) {
        TimetableSnapshotSource snapshotSource = (TimetableSnapshotSource)graph.getOrSetupTimetableSnapshotProvider(null);
        if (snapshotSource != null) {
            snapshotSource.applyTripUpdates(graph, this.fullDataset, this.updates, this.feedId);
        } else {
            LOG.error("Could not find realtime data snapshot source in graph. The following updates are not applied: {}", this.updates);
        }
    }
}

