/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.stoptime;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.graph.Graph;

public class TripPatternCache {
    private int counter = 0;
    private final Map<StopPattern, TripPattern> cache = new HashMap<StopPattern, TripPattern>();

    public synchronized TripPattern getOrCreateTripPattern(@NotNull StopPattern stopPattern, @NotNull Trip trip, @NotNull Graph graph) {
        Route route = trip.getRoute();
        TripPattern tripPattern = this.cache.get(stopPattern);
        if (tripPattern == null) {
            FeedScopedId id = this.generateUniqueTripPatternCode(trip);
            tripPattern = new TripPattern(id, route, stopPattern);
            tripPattern.setServiceCodes(graph.getServiceCodes());
            tripPattern.getScheduledTimetable().finish();
            TripPattern originalTripPattern = graph.index.getPatternForTrip().get(trip);
            tripPattern.setCreatedByRealtimeUpdater();
            if (originalTripPattern != null) {
                tripPattern.setOriginalTripPattern(originalTripPattern);
                tripPattern.setHopGeometriesFromPattern(originalTripPattern);
            }
            this.cache.put(stopPattern, tripPattern);
        }
        return tripPattern;
    }

    private FeedScopedId generateUniqueTripPatternCode(Trip trip) {
        FeedScopedId routeId = trip.getRoute().getId();
        String directionId = trip.getGtfsDirectionIdAsString("");
        this.counter = this.counter == Integer.MAX_VALUE ? 0 : ++this.counter;
        String code = String.format("%s:%s:%s:rt#%d", routeId.getFeedId(), routeId.getId(), directionId, this.counter);
        return new FeedScopedId(trip.getId().getFeedId(), code);
    }
}

