/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.stoptime;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.stoptime.GtfsRealtimeFileTripUpdateSource;
import org.opentripplanner.updater.stoptime.GtfsRealtimeHttpTripUpdateSource;
import org.opentripplanner.updater.stoptime.PollingStoptimeUpdaterParameters;
import org.opentripplanner.updater.stoptime.TimetableSnapshotSource;
import org.opentripplanner.updater.stoptime.TripUpdateGraphWriterRunnable;
import org.opentripplanner.updater.stoptime.TripUpdateSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingStoptimeUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingStoptimeUpdater.class);
    private WriteToGraphCallback saveResultOnGraph;
    private TripUpdateSource updateSource;
    private Integer logFrequency;
    private Integer maxSnapshotFrequency;
    private final Boolean purgeExpiredData;
    private final String feedId;
    private final boolean fuzzyTripMatching;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;

    public PollingStoptimeUpdater(PollingStoptimeUpdaterParameters parameters) {
        super(parameters);
        int maxSnapshotFrequency;
        this.feedId = parameters.getFeedId();
        this.updateSource = PollingStoptimeUpdater.createSource(parameters);
        int logFrequency = parameters.getLogFrequency();
        if (logFrequency >= 0) {
            this.logFrequency = logFrequency;
        }
        if ((maxSnapshotFrequency = parameters.getMaxSnapshotFrequencyMs()) >= 0) {
            this.maxSnapshotFrequency = maxSnapshotFrequency;
        }
        this.purgeExpiredData = parameters.purgeExpiredData();
        this.fuzzyTripMatching = parameters.fuzzyTripMatching();
        LOG.info("Creating stop time updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds, (Object)this.updateSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) {
        if (this.fuzzyTripMatching) {
            this.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new RoutingService(graph));
        }
        TimetableSnapshotSource snapshotSource = graph.getOrSetupTimetableSnapshotProvider(TimetableSnapshotSource::new);
        if (this.logFrequency != null) {
            snapshotSource.logFrequency = this.logFrequency;
        }
        if (this.maxSnapshotFrequency != null) {
            snapshotSource.maxSnapshotFrequency = this.maxSnapshotFrequency;
        }
        if (this.purgeExpiredData != null) {
            snapshotSource.purgeExpiredData = this.purgeExpiredData;
        }
        if (this.fuzzyTripMatcher != null) {
            snapshotSource.fuzzyTripMatcher = this.fuzzyTripMatcher;
        }
    }

    @Override
    public void runPolling() {
        List<GtfsRealtime.TripUpdate> updates = this.updateSource.getUpdates();
        boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
        if (updates != null) {
            TripUpdateGraphWriterRunnable runnable = new TripUpdateGraphWriterRunnable(fullDataset, updates, this.feedId);
            this.saveResultOnGraph.execute(runnable);
        }
    }

    @Override
    public void teardown() {
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Streaming stoptime updater with update source = " + s;
    }

    private static TripUpdateSource createSource(PollingStoptimeUpdaterParameters parameters) {
        switch (parameters.getSourceType()) {
            case GTFS_RT_HTTP: {
                return new GtfsRealtimeHttpTripUpdateSource(parameters.httpSourceParameters());
            }
            case GTFS_RT_FILE: {
                return new GtfsRealtimeFileTripUpdateSource(parameters.fileSourceParameters());
            }
        }
        throw new IllegalArgumentException("Unknown update streamer source type: " + parameters.getSourceType());
    }
}

