/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.stoptime;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.transit.realtime.GtfsRealtime;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.stoptime.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.stoptime.TimetableSnapshotSource;
import org.opentripplanner.updater.stoptime.TripUpdateGraphWriterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttGtfsRealtimeUpdater
implements GraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(MqttGtfsRealtimeUpdater.class);
    private WriteToGraphCallback saveResultOnGraph;
    private final String url;
    private final String topic;
    private final String feedId;
    private final int qos;
    private final boolean fuzzyTripMatching;
    private final String clientId = "OpenTripPlanner-" + MqttClient.generateClientId();
    private final String configRef;
    MemoryPersistence persistence = new MemoryPersistence();
    private MqttClient client;

    public MqttGtfsRealtimeUpdater(MqttGtfsRealtimeUpdaterParameters parameters) {
        this.configRef = parameters.getConfigRef();
        this.url = parameters.getUrl();
        this.topic = parameters.getTopic();
        this.feedId = parameters.getFeedId();
        this.qos = parameters.getQos();
        this.fuzzyTripMatching = parameters.getFuzzyTripMatching();
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) {
        TimetableSnapshotSource snapshotSource = graph.getOrSetupTimetableSnapshotProvider(TimetableSnapshotSource::new);
        if (this.fuzzyTripMatching) {
            snapshotSource.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new RoutingService(graph));
        }
    }

    @Override
    public void run() throws Exception {
        this.client = new MqttClient(this.url, this.clientId, (MqttClientPersistence)this.persistence);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setAutomaticReconnect(true);
        URI parsedUrl = new URI(this.url);
        if (parsedUrl.getUserInfo() != null) {
            String[] userinfo = parsedUrl.getUserInfo().split(":");
            connOpts.setUserName(userinfo[0]);
            connOpts.setPassword(userinfo[1].toCharArray());
        }
        this.client.setCallback((MqttCallback)new Callback());
        LOG.debug("Connecting to broker: " + this.url);
        this.client.connect(connOpts);
    }

    @Override
    public void teardown() {
        try {
            this.client.disconnect();
        }
        catch (MqttException e) {
            LOG.error("Error disconnecting", (Throwable)e);
        }
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }

    private class Callback
    implements MqttCallbackExtended {
        private Callback() {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            try {
                LOG.debug("Connected");
                MqttGtfsRealtimeUpdater.this.client.subscribe(MqttGtfsRealtimeUpdater.this.topic, MqttGtfsRealtimeUpdater.this.qos);
            }
            catch (MqttException e) {
                LOG.warn("Could not subscribe to: " + MqttGtfsRealtimeUpdater.this.topic);
            }
        }

        public void connectionLost(Throwable cause) {
            LOG.debug("Disconnected");
        }

        public void messageArrived(String topic, MqttMessage message) {
            ArrayList<GtfsRealtime.TripUpdate> updates = null;
            boolean fullDataset = true;
            try {
                GtfsRealtime.FeedMessage feedMessage = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(message.getPayload());
                List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Could not decode gtfs-rt message:", (Throwable)e);
            }
            if (updates != null) {
                MqttGtfsRealtimeUpdater.this.saveResultOnGraph.execute(new TripUpdateGraphWriterRunnable(fullDataset, updates, MqttGtfsRealtimeUpdater.this.feedId));
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

