/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.stoptime;

import com.google.transit.realtime.GtfsRealtime;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.updater.stoptime.TripUpdateSource;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeHttpTripUpdateSource
implements TripUpdateSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeHttpTripUpdateSource.class);
    private boolean fullDataset = true;
    private final String feedId;
    private final String url;

    public GtfsRealtimeHttpTripUpdateSource(Parameters config) {
        this.feedId = config.getFeedId();
        this.url = config.getUrl();
    }

    @Override
    public List<GtfsRealtime.TripUpdate> getUpdates() {
        GtfsRealtime.FeedMessage feedMessage = null;
        List<GtfsRealtime.FeedEntity> feedEntityList = null;
        ArrayList<GtfsRealtime.TripUpdate> updates = null;
        this.fullDataset = true;
        try {
            InputStream is = HttpUtils.getData(URI.create(this.url), Map.of("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*"));
            if (is != null) {
                feedMessage = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(is);
                feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    this.fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to parse gtfs-rt feed from " + this.url + ":", (Throwable)e);
        }
        return updates;
    }

    @Override
    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    public String toString() {
        return "GtfsRealtimeHttpUpdateStreamer(" + this.url + ")";
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    static interface Parameters {
        public String getFeedId();

        public String getUrl();
    }
}

