/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alerts;

import com.google.transit.realtime.GtfsRealtime;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.alerts.AlertsUpdateHandler;
import org.opentripplanner.updater.alerts.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeAlertsUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeAlertsUpdater.class);
    private WriteToGraphCallback saveResultOnGraph;
    private Long lastTimestamp = Long.MIN_VALUE;
    private final String url;
    private final String feedId;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;
    private final long earlyStart;
    private AlertsUpdateHandler updateHandler = null;
    private final boolean fuzzyTripMatching;
    private TransitAlertService transitAlertService;

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    public GtfsRealtimeAlertsUpdater(GtfsRealtimeAlertsUpdaterParameters config) {
        super(config);
        this.url = config.getUrl();
        this.earlyStart = config.getEarlyStartSec();
        this.feedId = config.getFeedId();
        this.fuzzyTripMatching = config.fuzzyTripMatching();
        LOG.info("Creating real-time alert updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds, (Object)this.url);
    }

    @Override
    public void setup(Graph graph) {
        TransitAlertServiceImpl transitAlertService = new TransitAlertServiceImpl(graph);
        if (this.fuzzyTripMatching) {
            this.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new RoutingService(graph));
        }
        this.transitAlertService = transitAlertService;
        if (this.updateHandler == null) {
            this.updateHandler = new AlertsUpdateHandler();
        }
        this.updateHandler.setEarlyStart(this.earlyStart);
        this.updateHandler.setFeedId(this.feedId);
        this.updateHandler.setTransitAlertService(transitAlertService);
        this.updateHandler.setFuzzyTripMatcher(this.fuzzyTripMatcher);
    }

    @Override
    protected void runPolling() {
        try {
            InputStream data = HttpUtils.getData(URI.create(this.url), Map.of("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*"));
            if (data == null) {
                throw new RuntimeException("Failed to get data from url " + this.url);
            }
            GtfsRealtime.FeedMessage feed = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(data);
            long feedTimestamp = feed.getHeader().getTimestamp();
            if (feedTimestamp <= this.lastTimestamp) {
                LOG.info("Ignoring feed with an old timestamp.");
                return;
            }
            this.saveResultOnGraph.execute(graph -> this.updateHandler.update(feed));
            this.lastTimestamp = feedTimestamp;
        }
        catch (Exception e) {
            LOG.error("Error reading gtfs-realtime feed from " + this.url, (Throwable)e);
        }
    }

    @Override
    public void teardown() {
    }

    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    public String toString() {
        return "GtfsRealtimeUpdater(" + this.url + ")";
    }
}

