/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.PollingGraphUpdaterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollingGraphUpdater
implements GraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingGraphUpdater.class);
    protected Integer pollingPeriodSeconds;
    protected boolean blockReadinessUntilInitialized;
    protected boolean primed;
    private final String configRef;

    protected abstract void runPolling() throws Exception;

    public PollingGraphUpdater(PollingGraphUpdaterParameters config) {
        this.pollingPeriodSeconds = config.getFrequencySec();
        this.configRef = config.getConfigRef();
    }

    @Override
    public final void run() {
        try {
            LOG.info("Polling updater started: {}", (Object)this);
            while (true) {
                block9: {
                    try {
                        this.runPolling();
                        if (this.pollingPeriodSeconds > 0) break block9;
                        LOG.info("As requested in configuration, updater {} has run only once and will now stop.", (Object)this.getClass().getSimpleName());
                        break;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error("Error while running polling updater of type {}", (Object)this.configRef, (Object)e);
                    }
                    finally {
                        this.primed = true;
                    }
                }
                Thread.sleep(this.pollingPeriodSeconds * 1000);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Polling updater {} was interrupted and is stopping.", (Object)this.getClass().getName());
        }
    }

    @Override
    public boolean isPrimed() {
        return this.primed;
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }
}

