/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import com.google.transit.realtime.GtfsRealtime;
import java.text.ParseException;
import java.util.BitSet;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.util.time.TimeUtils;

public class GtfsRealtimeFuzzyTripMatcher {
    private RoutingService routingService;
    private BitSet servicesRunningForDate;
    private ServiceDate date;

    public GtfsRealtimeFuzzyTripMatcher(RoutingService routingService) {
        this.routingService = routingService;
    }

    public GtfsRealtime.TripDescriptor match(String feedId, GtfsRealtime.TripDescriptor trip) {
        ServiceDate date;
        if (trip.hasTripId()) {
            return trip;
        }
        if (!(trip.hasRouteId() && trip.hasDirectionId() && trip.hasStartTime() && trip.hasStartDate())) {
            return trip;
        }
        FeedScopedId routeId = new FeedScopedId(feedId, trip.getRouteId());
        int time = TimeUtils.time(trip.getStartTime());
        try {
            date = ServiceDate.parseString(trip.getStartDate());
        }
        catch (ParseException e) {
            return trip;
        }
        Route route = this.routingService.getRouteForId(routeId);
        if (route == null) {
            return trip;
        }
        int direction = trip.getDirectionId();
        Trip matchedTrip = this.getTrip(route, direction, time, date);
        if (matchedTrip == null) {
            date = date.previous();
            matchedTrip = this.getTrip(route, direction, time += 86400, date);
        }
        if (matchedTrip == null) {
            return trip;
        }
        return trip.toBuilder().setTripId(matchedTrip.getId().getId()).build();
    }

    public synchronized Trip getTrip(Route route, int direction, int startTime, ServiceDate date) {
        if (!date.equals(this.date)) {
            this.date = date;
            this.servicesRunningForDate = this.routingService.getServicesRunningForDate(date);
        }
        for (TripPattern pattern : this.routingService.getPatternsForRoute().get((Object)route)) {
            if (pattern.getDirection().gtfsCode != direction) continue;
            for (TripTimes times : pattern.getScheduledTimetable().getTripTimes()) {
                if (times.getScheduledDepartureTime(0) != startTime || !this.servicesRunningForDate.get(times.getServiceCode())) continue;
                return times.getTrip();
            }
        }
        return null;
    }
}

