/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.ext.siri.updater.SiriETGooglePubsubUpdater;
import org.opentripplanner.ext.siri.updater.SiriETGooglePubsubUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriETUpdater;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriSXUpdater;
import org.opentripplanner.ext.siri.updater.SiriSXUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriVMUpdater;
import org.opentripplanner.ext.siri.updater.SiriVMUpdaterParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.VehicleRentalServiceDirectoryFetcher;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.opentripplanner.updater.UpdatersParameters;
import org.opentripplanner.updater.alerts.GtfsRealtimeAlertsUpdater;
import org.opentripplanner.updater.alerts.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.stoptime.MqttGtfsRealtimeUpdater;
import org.opentripplanner.updater.stoptime.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.stoptime.PollingStoptimeUpdater;
import org.opentripplanner.updater.stoptime.PollingStoptimeUpdaterParameters;
import org.opentripplanner.updater.stoptime.WebsocketGtfsRealtimeUpdater;
import org.opentripplanner.updater.stoptime.WebsocketGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.street_notes.WFSNotePollingGraphUpdaterParameters;
import org.opentripplanner.updater.street_notes.WinkkiPollingGraphUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingDataSourceFactory;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphUpdaterConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(GraphUpdaterConfigurator.class);

    public static void setupGraph(Graph graph, UpdatersParameters updatersParameters) {
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        updaters.addAll(GraphUpdaterConfigurator.createUpdatersFromConfig(updatersParameters));
        updaters.addAll(GraphUpdaterConfigurator.fetchVehicleRentalServicesFromOnlineDirectory(updatersParameters.getVehicleRentalServiceDirectoryFetcherParameters()));
        GraphUpdaterConfigurator.setupUpdaters(graph, updaters);
        GraphUpdaterManager updaterManager = new GraphUpdaterManager(graph, updaters);
        updaterManager.startUpdaters();
        if (updaterManager.numberOfUpdaters() == 0) {
            updaterManager.stop();
        } else {
            graph.updaterManager = updaterManager;
        }
    }

    public static void shutdownGraph(Graph graph) {
        GraphUpdaterManager updaterManager = graph.updaterManager;
        if (updaterManager != null) {
            LOG.info("Stopping updater manager with " + updaterManager.numberOfUpdaters() + " updaters.");
            updaterManager.stop();
        }
    }

    public static void setupUpdaters(Graph graph, List<GraphUpdater> updaters) {
        for (GraphUpdater updater : updaters) {
            try {
                updater.setup(graph);
            }
            catch (Exception e) {
                LOG.warn("Failed to setup updater {}", (Object)updater.getConfigRef());
            }
        }
    }

    private static List<GraphUpdater> fetchVehicleRentalServicesFromOnlineDirectory(VehicleRentalServiceDirectoryFetcherParameters parameters) {
        if (parameters == null) {
            return List.of();
        }
        return VehicleRentalServiceDirectoryFetcher.createUpdatersFromEndpoint(parameters);
    }

    private static List<GraphUpdater> createUpdatersFromConfig(UpdatersParameters config) {
        DataSource<Object> source;
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        for (VehicleRentalUpdaterParameters vehicleRentalUpdaterParameters : config.getVehicleRentalParameters()) {
            source = VehicleRentalDataSourceFactory.create(vehicleRentalUpdaterParameters.sourceParameters());
            updaters.add(new VehicleRentalUpdater(vehicleRentalUpdaterParameters, source));
        }
        for (GtfsRealtimeAlertsUpdaterParameters gtfsRealtimeAlertsUpdaterParameters : config.getGtfsRealtimeAlertsUpdaterParameters()) {
            updaters.add(new GtfsRealtimeAlertsUpdater(gtfsRealtimeAlertsUpdaterParameters));
        }
        for (PollingStoptimeUpdaterParameters pollingStoptimeUpdaterParameters : config.getPollingStoptimeUpdaterParameters()) {
            updaters.add(new PollingStoptimeUpdater(pollingStoptimeUpdaterParameters));
        }
        for (SiriETUpdaterParameters siriETUpdaterParameters : config.getSiriETUpdaterParameters()) {
            updaters.add(new SiriETUpdater(siriETUpdaterParameters));
        }
        for (SiriETGooglePubsubUpdaterParameters siriETGooglePubsubUpdaterParameters : config.getSiriETGooglePubsubUpdaterParameters()) {
            updaters.add(new SiriETGooglePubsubUpdater(siriETGooglePubsubUpdaterParameters));
        }
        for (SiriSXUpdaterParameters siriSXUpdaterParameters : config.getSiriSXUpdaterParameters()) {
            updaters.add(new SiriSXUpdater(siriSXUpdaterParameters));
        }
        for (SiriVMUpdaterParameters siriVMUpdaterParameters : config.getSiriVMUpdaterParameters()) {
            updaters.add(new SiriVMUpdater(siriVMUpdaterParameters));
        }
        for (WebsocketGtfsRealtimeUpdaterParameters websocketGtfsRealtimeUpdaterParameters : config.getWebsocketGtfsRealtimeUpdaterParameters()) {
            updaters.add(new WebsocketGtfsRealtimeUpdater(websocketGtfsRealtimeUpdaterParameters));
        }
        for (MqttGtfsRealtimeUpdaterParameters mqttGtfsRealtimeUpdaterParameters : config.getMqttGtfsRealtimeUpdaterParameters()) {
            updaters.add(new MqttGtfsRealtimeUpdater(mqttGtfsRealtimeUpdaterParameters));
        }
        for (VehicleParkingUpdaterParameters vehicleParkingUpdaterParameters : config.getVehicleParkingUpdaterParameters()) {
            source = VehicleParkingDataSourceFactory.create(vehicleParkingUpdaterParameters);
            updaters.add(new VehicleParkingUpdater(vehicleParkingUpdaterParameters, source));
        }
        for (WFSNotePollingGraphUpdaterParameters wFSNotePollingGraphUpdaterParameters : config.getWinkkiPollingGraphUpdaterParameters()) {
            updaters.add(new WinkkiPollingGraphUpdater(wFSNotePollingGraphUpdaterParameters));
        }
        return updaters;
    }
}

