/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.service;

import org.opentripplanner.transit.raptor.api.request.DynamicSearchWindowCoefficients;
import org.opentripplanner.transit.raptor.api.request.SearchParams;

public class RaptorSearchWindowCalculator {
    private final int NOT_SET = -9999999;
    private final double minTransitTimeCoefficient;
    private final double minWaitTimeCoefficient;
    private final int minSearchWinSeconds;
    private final int maxSearchWinSeconds;
    private final int stepSeconds;
    private int heuristicMinTransitTime = -9999999;
    private int heuristicMinWaitTime = -9999999;
    private int earliestDepartureTime = -9999999;
    private int latestArrivalTime = -9999999;
    private int searchWindowSeconds = -9999999;
    private SearchParams params;

    public RaptorSearchWindowCalculator(DynamicSearchWindowCoefficients c) {
        this.minTransitTimeCoefficient = c.minTransitTimeCoefficient();
        this.minWaitTimeCoefficient = c.minWaitTimeCoefficient();
        this.minSearchWinSeconds = c.minWinTimeMinutes() * 60;
        this.maxSearchWinSeconds = c.maxWinTimeMinutes() * 60;
        this.stepSeconds = c.stepMinutes() * 60;
    }

    public int getEarliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public int getLatestArrivalTime() {
        return this.latestArrivalTime;
    }

    public int getSearchWindowSeconds() {
        return this.searchWindowSeconds;
    }

    public RaptorSearchWindowCalculator withHeuristics(int minTransitTime, int minWaitTime) {
        this.heuristicMinTransitTime = minTransitTime;
        this.heuristicMinWaitTime = minWaitTime;
        return this;
    }

    public RaptorSearchWindowCalculator withSearchParams(SearchParams params) {
        this.params = params;
        this.searchWindowSeconds = params.searchWindowInSeconds();
        this.earliestDepartureTime = params.earliestDepartureTime();
        this.latestArrivalTime = params.latestArrivalTime();
        return this;
    }

    public RaptorSearchWindowCalculator calculate() {
        if (this.heuristicMinTransitTime == -9999999) {
            throw new IllegalArgumentException("The minTravelTime is not set.");
        }
        if (!this.params.isSearchWindowSet()) {
            this.searchWindowSeconds = this.calculateSearchWindow();
        }
        int travelWindow = this.searchWindowSeconds + this.roundUpToNearestMinute(this.heuristicMinTransitTime);
        if (!this.params.isEarliestDepartureTimeSet()) {
            this.earliestDepartureTime = this.latestArrivalTime - travelWindow;
        }
        return this;
    }

    int roundUpToNearestMinute(int minTravelTimeInSeconds) {
        if (minTravelTimeInSeconds < 0) {
            throw new IllegalArgumentException("This operation is not defined for negative numbers.");
        }
        return (minTravelTimeInSeconds + 59) / 60 * 60;
    }

    private int calculateSearchWindow() {
        if (this.params.isEarliestDepartureTimeSet() && this.params.isLatestArrivalTimeSet()) {
            int travelWindow = this.params.latestArrivalTime() - this.params.earliestDepartureTime();
            return this.roundStep(travelWindow - this.heuristicMinTransitTime);
        }
        int v = this.roundStep((double)this.minSearchWinSeconds + this.minTransitTimeCoefficient * (double)this.heuristicMinTransitTime + this.minWaitTimeCoefficient * (double)this.heuristicMinWaitTime);
        return Math.min(this.maxSearchWinSeconds, v);
    }

    int roundStep(double value) {
        return (int)Math.round(value / (double)this.stepSeconds) * this.stepSeconds;
    }
}

