/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import javax.annotation.Nullable;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;

public final class TripScheduleExactMatchSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T> {
    private final int slack;
    private final RaptorTripScheduleSearch<T> delegate;
    private final TransitCalculator<T> calculator;

    TripScheduleExactMatchSearch(RaptorTripScheduleSearch<T> delegate, TransitCalculator<T> calculator, int slack) {
        this.delegate = delegate;
        this.slack = slack;
        this.calculator = calculator;
    }

    @Override
    @Nullable
    public RaptorTripScheduleBoardOrAlightEvent<T> search(int timeLimit, int stopPositionInPattern, int tripIndexLimit) {
        RaptorTripScheduleBoardOrAlightEvent<T> result = this.delegate.search(timeLimit, stopPositionInPattern, tripIndexLimit);
        return result != null && this.isWithinSlack(timeLimit, result.getTime()) ? result : null;
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleExactMatchSearch.class).addNum("slack", this.slack).addObj("delegate", this.delegate).toString();
    }

    private boolean isWithinSlack(int timeLimit, int time) {
        return this.calculator.isBefore(time, timeLimit + this.slack);
    }
}

