/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTimeTable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;

public final class TripScheduleBoardSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T>,
RaptorTripScheduleBoardOrAlightEvent<T> {
    private static final int NOT_SET = -1;
    private final int nTripsBinarySearchThreshold;
    private final RaptorTimeTable<T> timeTable;
    private final int nTrips;
    private int earliestBoardTime;
    private int stopPositionInPattern;
    private IntUnaryOperator departureTimes;
    private T candidateTrip;
    private int candidateTripIndex = -1;

    TripScheduleBoardSearch(int scheduledTripBinarySearchThreshold, RaptorTimeTable<T> timeTable) {
        this.nTripsBinarySearchThreshold = scheduledTripBinarySearchThreshold;
        this.timeTable = timeTable;
        this.nTrips = timeTable.numberOfTripSchedules();
    }

    @Override
    public T getTrip() {
        return this.candidateTrip;
    }

    @Override
    public int getTripIndex() {
        return this.candidateTripIndex;
    }

    @Override
    public int getTime() {
        return this.candidateTrip.departure(this.stopPositionInPattern);
    }

    @Override
    public int getStopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    public RaptorTransferConstraint getTransferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    @Override
    public RaptorTripScheduleBoardOrAlightEvent<T> search(int earliestTime, int stopPositionInPattern, int tripIndexUpperBound) {
        this.earliestBoardTime = earliestTime;
        this.stopPositionInPattern = stopPositionInPattern;
        this.departureTimes = this.timeTable.getDepartureTimes(stopPositionInPattern);
        this.candidateTrip = null;
        this.candidateTripIndex = -1;
        if (tripIndexUpperBound == -1) {
            if (this.nTrips > this.nTripsBinarySearchThreshold) {
                return this.findFirstBoardingOptimizedForLargeSetOfTrips();
            }
            return this.findBoardingBySteppingBackwardsInTime(this.nTrips);
        }
        return this.findBoardingBySteppingBackwardsInTime(tripIndexUpperBound);
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleBoardSearch.class).addObj("nTrips", this.nTrips).addObj("earliestBoardTime", this.earliestBoardTime).addObj("stopPos", this.stopPositionInPattern).addObj("tripIndex", this.candidateTripIndex).addObj("trip", this.candidateTrip).toString();
    }

    private RaptorTripScheduleBoardOrAlightEvent<T> findFirstBoardingOptimizedForLargeSetOfTrips() {
        int indexBestGuess = this.binarySearchForTripIndex();
        RaptorTripScheduleBoardOrAlightEvent<T> result = this.findBoardingBySteppingBackwardsInTime(indexBestGuess);
        if (result != null) {
            return this;
        }
        return this.findBoardingBySteppingForwardInTime(indexBestGuess);
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingBySteppingBackwardsInTime(int tripIndexUpperBound) {
        int i = tripIndexUpperBound - 1;
        while (i >= 0 && this.departureTimes.applyAsInt(i) >= this.earliestBoardTime) {
            this.candidateTripIndex = i--;
        }
        if (this.candidateTripIndex == -1) {
            return null;
        }
        this.candidateTrip = this.timeTable.getTripSchedule(this.candidateTripIndex);
        return this;
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingBySteppingForwardInTime(int tripIndexLowerBound) {
        for (int i = tripIndexLowerBound; i < this.nTrips; ++i) {
            if (this.departureTimes.applyAsInt(i) < this.earliestBoardTime) continue;
            this.candidateTrip = this.timeTable.getTripSchedule(i);
            this.candidateTripIndex = i;
            return this;
        }
        return null;
    }

    private int binarySearchForTripIndex() {
        int lower = 0;
        int upper = this.nTrips;
        while (upper - lower > this.nTripsBinarySearchThreshold) {
            int m = (lower + upper) / 2;
            if (this.departureTimes.applyAsInt(m) >= this.earliestBoardTime) {
                upper = m;
                continue;
            }
            lower = m;
        }
        return upper == this.nTrips ? this.nTrips : upper + 1;
    }
}

