/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import org.opentripplanner.transit.raptor.rangeraptor.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;

public class RoundTracker
implements RoundProvider {
    private final int numberOfAdditionalTransfers;
    private int round = 0;
    private int roundMaxLimit;

    RoundTracker(int nRounds, int numberOfAdditionalTransfers, WorkerLifeCycle lifeCycle) {
        this.roundMaxLimit = nRounds;
        this.numberOfAdditionalTransfers = numberOfAdditionalTransfers;
        lifeCycle.onSetupIteration(this::setupIteration);
        lifeCycle.onRoundComplete(this::roundComplete);
    }

    private void setupIteration(int ignoreIterationDepartureTime) {
        this.round = 0;
    }

    private void roundComplete(boolean destinationReached) {
        if (destinationReached) {
            this.recalculateMaxLimitBasedOnDestinationReachedInCurrentRound();
        }
    }

    public boolean hasMoreRounds() {
        return this.round + 1 < this.roundMaxLimit;
    }

    public int nextRound() {
        return ++this.round;
    }

    @Override
    public int round() {
        return this.round;
    }

    public boolean isFirstRound() {
        return this.round == 1;
    }

    private void recalculateMaxLimitBasedOnDestinationReachedInCurrentRound() {
        this.roundMaxLimit = Math.min(this.roundMaxLimit, this.round + this.numberOfAdditionalTransfers + 1);
    }
}

