/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessEgressFunctions;

public class EgressPaths {
    private final TIntObjectMap<List<RaptorTransfer>> pathsByStop;

    private EgressPaths(TIntObjectMap<List<RaptorTransfer>> pathsByStop) {
        this.pathsByStop = pathsByStop;
    }

    static EgressPaths create(Collection<RaptorTransfer> paths, RaptorProfile profile) {
        if (!profile.is(RaptorProfile.MULTI_CRITERIA)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new EgressPaths(AccessEgressFunctions.groupByStop(paths));
    }

    public TIntObjectMap<List<RaptorTransfer>> byStop() {
        return this.pathsByStop;
    }

    public int[] stops() {
        return this.pathsByStop.keys();
    }

    public Collection<RaptorTransfer> listAll() {
        return this.pathsByStop.valueCollection().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

