/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessEgressFunctions;

public class AccessPaths {
    private final TIntObjectMap<List<RaptorTransfer>> arrivedOnStreetByNumOfRides;
    private final TIntObjectMap<List<RaptorTransfer>> arrivedOnBoardByNumOfRides;

    private AccessPaths(TIntObjectMap<List<RaptorTransfer>> arrivedOnStreetByNumOfRides, TIntObjectMap<List<RaptorTransfer>> arrivedOnBoardByNumOfRides) {
        this.arrivedOnStreetByNumOfRides = arrivedOnStreetByNumOfRides;
        this.arrivedOnBoardByNumOfRides = arrivedOnBoardByNumOfRides;
    }

    static AccessPaths create(Collection<RaptorTransfer> paths, RaptorProfile profile) {
        if (!profile.is(RaptorProfile.MULTI_CRITERIA)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new AccessPaths(AccessEgressFunctions.groupByRound(paths, Predicate.not(RaptorTransfer::hasRides)), AccessEgressFunctions.groupByRound(paths, RaptorTransfer::hasRides));
    }

    public TIntObjectMap<List<RaptorTransfer>> arrivedOnStreetByNumOfRides() {
        return this.arrivedOnStreetByNumOfRides;
    }

    public TIntObjectMap<List<RaptorTransfer>> arrivedOnBoardByNumOfRides() {
        return this.arrivedOnBoardByNumOfRides;
    }

    public int calculateMaxNumberOfRides() {
        return Math.max(Arrays.stream(this.arrivedOnStreetByNumOfRides.keys()).max().orElse(0), Arrays.stream(this.arrivedOnBoardByNumOfRides.keys()).max().orElse(0));
    }
}

