/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.rangeraptor.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TimeCalculator;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoSet;

public final class AccessEgressFunctions {
    private static final ParetoComparator<RaptorTransfer> STANDARD_COMPARATOR = (l, r) -> l.stopReachedOnBoard() && !r.stopReachedOnBoard() || !l.hasOpeningHours() && r.hasOpeningHours() || l.numberOfRides() < r.numberOfRides() || l.durationInSeconds() < r.durationInSeconds();

    private AccessEgressFunctions() {
    }

    public static int calculateEgressDepartureTime(int arrivalTime, RaptorTransfer egressPath, SlackProvider slackProvider, TimeCalculator timeCalculator) {
        int departureTime = arrivalTime;
        if (egressPath.stopReachedOnBoard()) {
            departureTime = timeCalculator.plusDuration(departureTime, slackProvider.accessEgressWithRidesTransferSlack());
        }
        if (timeCalculator.searchForward()) {
            return egressPath.earliestDepartureTime(departureTime);
        }
        return egressPath.latestArrivalTime(departureTime);
    }

    static Collection<RaptorTransfer> removeNoneOptimalPathsForStandardRaptor(Collection<RaptorTransfer> paths) {
        TIntObjectMap<List<RaptorTransfer>> mapByStop = AccessEgressFunctions.groupByStop(paths);
        ParetoSet<RaptorTransfer> set = new ParetoSet<RaptorTransfer>(STANDARD_COMPARATOR);
        ArrayList<RaptorTransfer> result = new ArrayList<RaptorTransfer>();
        mapByStop.forEachValue(list -> {
            set.clear();
            set.addAll(list);
            result.addAll(set);
            return true;
        });
        return result;
    }

    static TIntObjectMap<List<RaptorTransfer>> groupByRound(Collection<RaptorTransfer> input, Predicate<RaptorTransfer> include) {
        return AccessEgressFunctions.groupBy(input.stream().filter(include).collect(Collectors.toList()), RaptorTransfer::numberOfRides);
    }

    static TIntObjectMap<List<RaptorTransfer>> groupByStop(Collection<RaptorTransfer> input) {
        return AccessEgressFunctions.groupBy(input, RaptorTransfer::stop);
    }

    private static List<RaptorTransfer> getOrCreate(int key, TIntObjectMap<List<RaptorTransfer>> map) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        return (List)map.get(key);
    }

    private static TIntObjectMap<List<RaptorTransfer>> groupBy(Collection<RaptorTransfer> input, ToIntFunction<RaptorTransfer> groupBy) {
        TIntObjectHashMap mapByRound = new TIntObjectHashMap();
        for (RaptorTransfer it : input) {
            AccessEgressFunctions.getOrCreate(groupBy.applyAsInt(it), (TIntObjectMap<List<RaptorTransfer>>)mapByRound).add(it);
        }
        return mapByRound;
    }
}

