/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.path;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.standard.ArrivedAtDestinationCheck;
import org.opentripplanner.transit.raptor.rangeraptor.standard.DestinationArrivalListener;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.util.time.TimeUtils;

public class EgressArrivalToPathAdapter<T extends RaptorTripSchedule>
implements ArrivedAtDestinationCheck,
DestinationArrivalListener {
    private final DestinationArrivalPaths<T> paths;
    private final TransitCalculator<T> calculator;
    private final StopsCursor<T> cursor;
    private final List<DestinationArrivalEvent> rejectedArrivals;
    private int bestDestinationTime = -1;
    private DestinationArrivalEvent bestArrival = null;

    public EgressArrivalToPathAdapter(DestinationArrivalPaths<T> paths, TransitCalculator<T> calculator, StopsCursor<T> cursor, WorkerLifeCycle lifeCycle) {
        this.paths = paths;
        this.calculator = calculator;
        this.cursor = cursor;
        this.rejectedArrivals = paths.isDebugOn() ? new ArrayList() : null;
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onRoundComplete(ignore -> this.roundComplete());
    }

    @Override
    public void newDestinationArrival(int round, int fromStopArrivalTime, boolean stopReachedOnBoard, RaptorTransfer egressPath) {
        int arrivalTime = this.calculator.plusDuration(fromStopArrivalTime, egressPath.durationInSeconds());
        if (this.calculator.isBefore(arrivalTime, this.bestDestinationTime)) {
            this.debugRejectCurrentBestArrival();
            this.bestDestinationTime = arrivalTime;
            this.bestArrival = new DestinationArrivalEvent(round, stopReachedOnBoard, egressPath);
        } else {
            this.debugRejectNew(round, stopReachedOnBoard, egressPath);
        }
    }

    private boolean newElementSet() {
        return this.bestArrival != null;
    }

    private void setupIteration() {
        this.bestArrival = null;
        this.bestDestinationTime = this.calculator.unreachedTime();
    }

    private void roundComplete() {
        if (this.newElementSet()) {
            this.addNewElementToPath();
            this.logDebugRejectEvents();
            this.bestArrival = null;
        }
    }

    @Override
    public boolean arrivedAtDestinationCurrentRound() {
        return this.newElementSet();
    }

    private void addNewElementToPath() {
        this.paths.add(this.bestArrival.toArrivalState(this.cursor), this.bestArrival.egressPath);
    }

    private void debugRejectNew(int round, boolean stopReachedOnBoard, RaptorTransfer egressPath) {
        if (this.paths.isDebugOn()) {
            this.rejectedArrivals.add(new DestinationArrivalEvent(round, stopReachedOnBoard, egressPath));
        }
    }

    private void debugRejectCurrentBestArrival() {
        if (this.paths.isDebugOn() && this.newElementSet()) {
            this.rejectedArrivals.add(this.bestArrival);
        }
    }

    private void logDebugRejectEvents() {
        if (this.paths.isDebugOn()) {
            String reason = "Arrival time > " + TimeUtils.timeToStrCompact(this.bestDestinationTime);
            for (DestinationArrivalEvent it : this.rejectedArrivals) {
                this.paths.debugReject(it.toArrivalState(this.cursor), it.egressPath, reason);
            }
        }
    }

    private static class DestinationArrivalEvent {
        final int round;
        final boolean stopReachedOnBoard;
        final RaptorTransfer egressPath;

        private DestinationArrivalEvent(int round, boolean stopReachedOnBoard, RaptorTransfer egressPath) {
            this.round = round;
            this.stopReachedOnBoard = stopReachedOnBoard;
            this.egressPath = egressPath;
        }

        <T extends RaptorTripSchedule> ArrivalView<T> toArrivalState(StopsCursor<T> cursor) {
            return cursor.stop(this.round, this.egressPath.stop(), this.stopReachedOnBoard);
        }

        public String toString() {
            return ToStringBuilder.of(DestinationArrivalEvent.class).addNum("round", this.round).addBool("stopReachedOnBoard", this.stopReachedOnBoard).addObj("egressPath", this.egressPath).toString();
        }
    }
}

