/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals;

import java.util.Collection;
import java.util.List;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.standard.DestinationArrivalListener;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.DefaultStopArrivalState;

final class EgressStopArrivalState<T extends RaptorTripSchedule>
extends DefaultStopArrivalState<T> {
    private final int round;
    private final int stop;
    private final RaptorTransfer[] egressPaths;
    private final DestinationArrivalListener callback;

    EgressStopArrivalState(int stop, int round, Collection<RaptorTransfer> egressPaths, DestinationArrivalListener transitCallback) {
        this.round = round;
        this.stop = stop;
        this.egressPaths = egressPaths.toArray(new RaptorTransfer[0]);
        this.callback = transitCallback;
    }

    public int round() {
        return this.round;
    }

    public int stop() {
        return this.stop;
    }

    @Override
    public void transferToStop(int fromStop, int arrivalTime, RaptorTransfer transferPath) {
        super.transferToStop(fromStop, arrivalTime, transferPath);
        for (RaptorTransfer egressPath : this.egressPaths) {
            if (!egressPath.stopReachedOnBoard()) continue;
            this.callback.newDestinationArrival(this.round, arrivalTime, transferPath.stopReachedOnBoard(), egressPath);
        }
    }

    @Override
    public void arriveByTransit(int arrivalTime, int boardStop, int boardTime, T trip) {
        super.arriveByTransit(arrivalTime, boardStop, boardTime, trip);
        for (RaptorTransfer egressPath : this.egressPaths) {
            this.callback.newDestinationArrival(this.round, arrivalTime, true, egressPath);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(EgressStopArrivalState.class).addNum("stop", this.stop).addNum("round", this.round);
        this.toStringAddBody(builder);
        builder.addCol("egressPaths", List.of(this.egressPaths));
        return builder.toString();
    }
}

