/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.heuristics;

import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.view.Heuristics;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.standard.BestNumberOfTransfers;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.transit.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.util.IntUtils;
import org.opentripplanner.util.time.TimeUtils;

public class HeuristicsAdapter
implements Heuristics {
    private static final int NOT_SET = Integer.MAX_VALUE;
    private int originDepartureTime = -1;
    private final BestTimes times;
    private final BestNumberOfTransfers transfers;
    private final TIntObjectMap<List<RaptorTransfer>> egressPaths;
    private final TransitCalculator<?> calculator;
    private boolean aggregatedResultsCalculated = false;
    private int minJourneyTravelDuration = Integer.MAX_VALUE;
    private int minJourneyNumOfTransfers = Integer.MAX_VALUE;
    private int earliestArrivalTime = Integer.MAX_VALUE;

    public HeuristicsAdapter(BestTimes times, BestNumberOfTransfers transfers, EgressPaths egressPaths, TransitCalculator<?> calculator, WorkerLifeCycle lifeCycle) {
        this.times = times;
        this.transfers = transfers;
        this.egressPaths = egressPaths.byStop();
        this.calculator = calculator;
        lifeCycle.onSetupIteration(this::setUpIteration);
    }

    private void setUpIteration(int departureTime) {
        if (this.originDepartureTime > 0) {
            throw new IllegalStateException("You should only run one iteration to calculate heuristics, this is because we use the origin departure time to calculate the travel duration at the end of the search.");
        }
        this.originDepartureTime = departureTime;
    }

    @Override
    public boolean reached(int stop) {
        return this.times.isStopReached(stop);
    }

    @Override
    public int bestTravelDuration(int stop) {
        if (this.reached(stop)) {
            return this.calculator.duration(this.originDepartureTime, this.times.time(stop));
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int[] bestTravelDurationToIntArray(int unreached) {
        return this.toIntArray(this.size(), unreached, this::bestTravelDuration);
    }

    @Override
    public int bestNumOfTransfers(int stop) {
        return this.transfers.calculateMinNumberOfTransfers(stop);
    }

    @Override
    public int[] bestNumOfTransfersToIntArray(int unreached) {
        return this.toIntArray(this.size(), unreached, this::bestNumOfTransfers);
    }

    @Override
    public int size() {
        return this.times.size();
    }

    @Override
    public int bestOverallJourneyTravelDuration() {
        this.calculateAggregatedResults();
        return this.minJourneyTravelDuration;
    }

    @Override
    public int bestOverallJourneyNumOfTransfers() {
        this.calculateAggregatedResults();
        return this.minJourneyNumOfTransfers;
    }

    @Override
    public int minWaitTimeForJourneysReachingDestination() {
        this.calculateAggregatedResults();
        return Math.abs(this.earliestArrivalTime - this.originDepartureTime) - this.minJourneyTravelDuration;
    }

    @Override
    public boolean destinationReached() {
        this.calculateAggregatedResults();
        return this.minJourneyNumOfTransfers != Integer.MAX_VALUE;
    }

    public String toString() {
        return ToStringBuilder.of(Heuristics.class).addServiceTime("originDepartureTime(last iteration)", this.originDepartureTime).addBoolIfTrue("resultsExist", this.aggregatedResultsCalculated).addDurationSec("minJourneyTravelDuration", this.minJourneyTravelDuration, Integer.MAX_VALUE).addDurationSec("minJourneyNumOfTransfers", this.minJourneyNumOfTransfers, Integer.MAX_VALUE).addServiceTime("earliestArrivalTime", this.earliestArrivalTime, Integer.MAX_VALUE).addObj("times", this.times).addCollection("egress stops reached", Arrays.stream(this.egressPaths.keys()).filter(this.times::isStopReached).mapToObj(s -> "[" + s + " " + TimeUtils.timeToStrCompact(this.times.time(s)) + "]").collect(Collectors.toList()), 20).toString();
    }

    private void calculateAggregatedResults() {
        if (this.aggregatedResultsCalculated) {
            return;
        }
        this.egressPaths.forEachEntry((stop, list) -> {
            boolean stopReached = this.times.isStopReached(stop);
            boolean stopReachedByTransit = this.times.isStopReachedOnBoard(stop);
            if (stopReached || stopReachedByTransit) {
                for (RaptorTransfer it : list) {
                    boolean destinationReached;
                    boolean bl = destinationReached = it.stopReachedOnBoard() ? stopReached : stopReachedByTransit;
                    if (!destinationReached) continue;
                    int t = this.bestTravelDuration(it.stop()) + it.durationInSeconds();
                    this.minJourneyTravelDuration = Math.min(this.minJourneyTravelDuration, t);
                    int n = this.bestNumOfTransfers(it.stop());
                    this.minJourneyNumOfTransfers = Math.min(this.minJourneyNumOfTransfers, n);
                    int eat = this.times.time(it.stop()) + it.durationInSeconds();
                    this.earliestArrivalTime = Math.min(this.earliestArrivalTime, eat);
                }
            }
            return true;
        });
        this.aggregatedResultsCalculated = true;
    }

    private int[] toIntArray(int size, int unreached, IntUnaryOperator supplier) {
        int[] a = IntUtils.intArray(size, unreached);
        for (int i = 0; i < a.length; ++i) {
            if (!this.reached(i)) continue;
            a[i] = supplier.applyAsInt(i);
        }
        return a;
    }
}

