/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes;

import org.opentripplanner.transit.raptor.rangeraptor.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.standard.BestNumberOfTransfers;
import org.opentripplanner.transit.raptor.util.IntUtils;

public class SimpleBestNumberOfTransfers
implements BestNumberOfTransfers {
    private final int[] bestNumOfTransfers;
    private final RoundProvider roundProvider;

    public SimpleBestNumberOfTransfers(int nStops, RoundProvider roundProvider) {
        this.bestNumOfTransfers = IntUtils.intArray(nStops, this.unreachedMinNumberOfTransfers());
        this.roundProvider = roundProvider;
    }

    void arriveAtStop(int stop) {
        int numOfTransfers = this.roundProvider.round() - 1;
        if (numOfTransfers < this.bestNumOfTransfers[stop]) {
            this.bestNumOfTransfers[stop] = numOfTransfers;
        }
    }

    @Override
    public int calculateMinNumberOfTransfers(int stop) {
        return this.bestNumOfTransfers[stop];
    }
}

