/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes;

import java.util.BitSet;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.util.BitSetIterator;
import org.opentripplanner.transit.raptor.util.IntUtils;

public final class BestTimes {
    private final int[] times;
    private final int[] onBoardTimes;
    private BitSet reachedCurrentRound;
    private final BitSet onBoardReachedCurrentRound;
    private BitSet reachedLastRound;
    private final TransitCalculator<?> calculator;

    public BestTimes(int nStops, TransitCalculator<?> calculator, WorkerLifeCycle lifeCycle) {
        this.calculator = calculator;
        this.times = IntUtils.intArray(nStops, calculator.unreachedTime());
        this.reachedCurrentRound = new BitSet(nStops);
        this.reachedLastRound = new BitSet(nStops);
        this.onBoardTimes = IntUtils.intArray(nStops, calculator.unreachedTime());
        this.onBoardReachedCurrentRound = new BitSet(nStops);
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onPrepareForNextRound(round -> this.prepareForNextRound());
    }

    public int time(int stop) {
        return this.times[stop];
    }

    public int onBoardTime(int stop) {
        return this.onBoardTimes[stop];
    }

    private void setupIteration() {
        this.reachedCurrentRound.clear();
        this.onBoardReachedCurrentRound.clear();
    }

    public boolean isCurrentRoundUpdated() {
        return !this.reachedCurrentRound.isEmpty();
    }

    private void prepareForNextRound() {
        this.swapReachedCurrentAndLastRound();
        this.reachedCurrentRound.clear();
        this.onBoardReachedCurrentRound.clear();
    }

    public BitSetIterator stopsReachedLastRound() {
        return new BitSetIterator(this.reachedLastRound);
    }

    public BitSetIterator onBoardStopArrivalsReachedCurrentRound() {
        return new BitSetIterator(this.onBoardReachedCurrentRound);
    }

    boolean isStopReachedOnBoardInCurrentRound(int stop) {
        return this.onBoardReachedCurrentRound.get(stop);
    }

    public boolean isStopReachedLastRound(int stop) {
        return this.reachedLastRound.get(stop);
    }

    public boolean isStopReached(int stop) {
        return this.time(stop) != this.calculator.unreachedTime();
    }

    public boolean isStopReachedOnBoard(int stop) {
        return this.onBoardTime(stop) != this.calculator.unreachedTime();
    }

    public boolean updateOnBoardBestTime(int stop, int time) {
        if (this.isBestOnBoardTime(stop, time)) {
            this.setBestTime(stop, time);
            return true;
        }
        return false;
    }

    public boolean updateNewBestTime(int stop, int time) {
        if (this.isBestTime(stop, time)) {
            this.setTime(stop, time);
            return true;
        }
        return false;
    }

    public int size() {
        return this.times.length;
    }

    public String toString() {
        int unreachedTime = this.calculator.unreachedTime();
        return ToStringBuilder.of(BestTimes.class).addIntArraySize("times", this.times, unreachedTime).addIntArraySize("onBoardTimes", this.onBoardTimes, unreachedTime).addNum("reachedCurrentRound", this.reachedCurrentRound.size()).addBitSetSize("onBoardReachedCurrentRound", this.onBoardReachedCurrentRound).addBitSetSize("reachedLastRound", this.reachedLastRound).toString();
    }

    private void setTime(int stop, int time) {
        this.times[stop] = time;
        this.reachedCurrentRound.set(stop);
    }

    private boolean isBestTime(int stop, int time) {
        return this.calculator.isBefore(time, this.times[stop]);
    }

    private boolean isBestOnBoardTime(int stop, int time) {
        return this.calculator.isBefore(time, this.onBoardTimes[stop]);
    }

    private void setBestTime(int stop, int time) {
        this.onBoardTimes[stop] = time;
        this.onBoardReachedCurrentRound.set(stop);
    }

    private void swapReachedCurrentAndLastRound() {
        BitSet tmp = this.reachedLastRound;
        this.reachedLastRound = this.reachedCurrentRound;
        this.reachedCurrentRound = tmp;
    }
}

