/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard;

import java.util.function.IntConsumer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;

public final class MinTravelDurationRoutingStrategy<T extends RaptorTripSchedule>
implements RoutingStrategy<T> {
    private static final int NOT_SET = -1;
    private final TransitCalculator<T> calculator;
    private final StdWorkerState<T> state;
    private int onTripIndex;
    private int onTripBoardTime;
    private int onTripBoardStop;
    private T onTrip;
    private int onTripTimeShift;

    public MinTravelDurationRoutingStrategy(TransitCalculator<T> calculator, StdWorkerState<T> state) {
        this.calculator = calculator;
        this.state = state;
    }

    @Override
    public void setAccessToStop(RaptorTransfer accessPath, int iterationDepartureTime, int timeDependentDepartureTime) {
        this.state.setAccessToStop(accessPath, iterationDepartureTime);
    }

    @Override
    public int onTripIndex() {
        return this.onTripIndex;
    }

    @Override
    public void prepareForTransitWith(RaptorTripPattern pattern) {
        this.onTripIndex = -1;
        this.onTripBoardTime = -1;
        this.onTripBoardStop = -1;
        this.onTrip = null;
        this.onTripTimeShift = -1;
    }

    @Override
    public void alight(int stopIndex, int stopPos, int alightSlack) {
        if (this.onTripIndex != -1) {
            int stopArrivalTime0 = this.calculator.stopArrivalTime(this.onTrip, stopPos, alightSlack);
            int stopArrivalTime = stopArrivalTime0 - this.onTripTimeShift;
            this.state.transitToStop(stopIndex, stopArrivalTime, this.onTripBoardStop, this.onTripBoardTime, this.onTrip);
        }
    }

    @Override
    public void forEachBoarding(int stopIndex, IntConsumer prevStopArrivalTimeConsumer) {
        if (this.state.isStopReachedInPreviousRound(stopIndex)) {
            prevStopArrivalTimeConsumer.accept(this.state.bestTimePreviousRound(stopIndex));
        }
    }

    @Override
    public void board(int stopIndex, int earliestBoardTime, RaptorTripScheduleBoardOrAlightEvent<T> boarding) {
        this.onTripIndex = boarding.getTripIndex();
        this.onTrip = boarding.getTrip();
        this.onTripBoardTime = earliestBoardTime;
        this.onTripBoardStop = stopIndex;
        this.onTripTimeShift = boarding.getTime() - this.onTripBoardTime;
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        return this.state.previousTransit(boardStopIndex);
    }

    @Override
    public void boardSameTrip(int earliestBoardTime, int stopPos, int stopIndex) {
        if (this.onTripIndex == -1) {
            return;
        }
        int tripBoardingTime = this.onTrip.departure(stopPos);
        if (this.calculator.isAfter(earliestBoardTime, tripBoardingTime)) {
            return;
        }
        int tripTimeShift = tripBoardingTime - earliestBoardTime;
        if (this.calculator.isBefore(tripTimeShift, this.onTripTimeShift)) {
            return;
        }
        this.onTripBoardTime = earliestBoardTime;
        this.onTripBoardStop = stopIndex;
        this.onTripTimeShift = tripTimeShift;
    }
}

