/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.path;

import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathBuilder;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.api.view.TransitPathView;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.path.BoardAndAlightTimeSearch;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TripTimesSearch;

public final class ReversePathMapper<T extends RaptorTripSchedule>
implements PathMapper<T> {
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    private final RaptorSlackProvider slackProvider;
    private final CostCalculator costCalculator;
    private final RaptorStopNameResolver stopNameResolver;
    private final BoardAndAlightTimeSearch tripSearch;
    private int iterationDepartureTime = -1;

    public ReversePathMapper(RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, CostCalculator costCalculator, RaptorStopNameResolver stopNameResolver, WorkerLifeCycle lifeCycle, boolean useApproximateTripTimesSearch) {
        this.transferConstraintsSearch = transferConstraintsSearch;
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
        this.tripSearch = ReversePathMapper.tripTimesSearch(useApproximateTripTimesSearch);
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    private void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }

    @Override
    public Path<T> mapToPath(DestinationArrival<T> destinationArrival) {
        PathBuilder<T> pathBuilder = PathBuilder.tailPathBuilder(this.transferConstraintsSearch, this.slackProvider, this.costCalculator, this.stopNameResolver);
        ArrivalView<T> arrival = destinationArrival.previous();
        pathBuilder.access(destinationArrival.egressPath().egress());
        while (true) {
            if (arrival.arrivedByAccess()) {
                pathBuilder.egress(arrival.accessPath().access());
                return pathBuilder.build(this.iterationDepartureTime);
            }
            if (arrival.arrivedByTransit()) {
                BoardAndAlightTime times = this.tripSearch.find(arrival);
                TransitPathView<T> transit = arrival.transitPath();
                pathBuilder.transit(transit.trip(), times);
            } else if (arrival.arrivedByTransfer()) {
                pathBuilder.transfer(arrival.transferPath().transfer(), arrival.previous().stop());
            } else {
                throw new IllegalStateException("Unexpected arrival: " + arrival);
            }
            arrival = arrival.previous();
        }
    }

    private static BoardAndAlightTimeSearch tripTimesSearch(boolean useApproximateTimeSearch) {
        return useApproximateTimeSearch ? TripTimesSearch::findTripReverseSearchApproximateTime : TripTimesSearch::findTripReverseSearch;
    }
}

