/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.path;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.model.base.OtpNumberFormat;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessEgressFunctions;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.rangeraptor.view.DebugHandler;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoSet;
import org.opentripplanner.util.logging.ThrottleLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationArrivalPaths<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(DestinationArrivalPaths.class);
    private static final Logger LOG_MISS_MATCH = ThrottleLogger.throttle(LOG);
    private final ParetoSet<Path<T>> paths;
    private final TransitCalculator<T> transitCalculator;
    @Nullable
    private final CostCalculator costCalculator;
    private final SlackProvider slackProvider;
    private final PathMapper<T> pathMapper;
    private final DebugHandler<Path<?>> debugPathHandler;
    private final RaptorStopNameResolver stopNameResolver;
    private boolean reachedCurrentRound = false;
    private int iterationDepartureTime = -1;

    public DestinationArrivalPaths(ParetoComparator<Path<T>> paretoComparator, TransitCalculator<T> transitCalculator, @Nullable CostCalculator costCalculator, SlackProvider slackProvider, PathMapper<T> pathMapper, DebugHandlerFactory<T> debugHandlerFactory, RaptorStopNameResolver stopNameResolver, WorkerLifeCycle lifeCycle) {
        this.paths = new ParetoSet(paretoComparator, debugHandlerFactory.paretoSetDebugPathListener());
        this.transitCalculator = transitCalculator;
        this.costCalculator = costCalculator;
        this.slackProvider = slackProvider;
        this.pathMapper = pathMapper;
        this.debugPathHandler = debugHandlerFactory.debugPathArrival();
        this.stopNameResolver = stopNameResolver;
        lifeCycle.onPrepareForNextRound(round -> this.clearReachedCurrentRoundFlag());
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    public void add(ArrivalView<T> stopArrival, RaptorTransfer egressPath) {
        DestinationArrival<T> destArrival = this.createDestinationArrivalView(stopArrival, egressPath);
        if (destArrival == null) {
            return;
        }
        if (this.transitCalculator.exceedsTimeLimit(destArrival.arrivalTime())) {
            this.debugRejectByTimeLimitOptimization(destArrival);
        } else {
            Path<T> path = this.pathMapper.mapToPath(destArrival);
            this.assertGeneralizedCostIsCalculatedCorrectByMapper(destArrival, path);
            boolean added = this.paths.add(path);
            if (added) {
                this.reachedCurrentRound = true;
            }
        }
    }

    public boolean isReachedCurrentRound() {
        return this.reachedCurrentRound;
    }

    public void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public boolean qualify(int departureTime, int arrivalTime, int numberOfTransfers, int cost) {
        return this.paths.qualify(Path.dummyPath(this.iterationDepartureTime, departureTime, arrivalTime, numberOfTransfers, cost));
    }

    public Collection<Path<T>> listPaths() {
        return this.paths;
    }

    public void debugReject(ArrivalView<T> stopArrival, RaptorTransfer egress, String reason) {
        if (this.isDebugOn()) {
            this.debugReject(this.createDestinationArrivalView(stopArrival, egress), reason);
        }
    }

    public void debugReject(DestinationArrival<T> arrival, String reason) {
        if (this.isDebugOn()) {
            Path<T> path = this.pathMapper.mapToPath(arrival);
            this.debugPathHandler.reject(path, null, reason);
        }
    }

    public String toString() {
        return this.paths.toString(p -> p.toString(this.stopNameResolver));
    }

    public final boolean isDebugOn() {
        return this.debugPathHandler != null;
    }

    private void clearReachedCurrentRoundFlag() {
        this.reachedCurrentRound = false;
    }

    private void debugRejectByTimeLimitOptimization(DestinationArrival<T> destArrival) {
        if (this.isDebugOn()) {
            this.debugReject(destArrival, this.transitCalculator.exceedsTimeLimitReason());
        }
    }

    private DestinationArrival<T> createDestinationArrivalView(ArrivalView<T> stopArrival, RaptorTransfer egressPath) {
        int departureTime = AccessEgressFunctions.calculateEgressDepartureTime(stopArrival.arrivalTime(), egressPath, this.slackProvider, this.transitCalculator);
        if (departureTime == -1) {
            return null;
        }
        int arrivalTime = this.transitCalculator.plusDuration(departureTime, egressPath.durationInSeconds());
        int waitTimeInSeconds = Math.abs(departureTime - stopArrival.arrivalTime());
        int additionalCost = 0;
        if (this.costCalculator != null) {
            additionalCost += this.costCalculator.waitCost(waitTimeInSeconds);
            additionalCost += this.costCalculator.costEgress(egressPath);
        }
        return new DestinationArrival<T>(egressPath, stopArrival, arrivalTime, additionalCost);
    }

    private void assertGeneralizedCostIsCalculatedCorrectByMapper(DestinationArrival<T> destArrival, Path<T> path) {
        if (path.generalizedCost() != destArrival.cost()) {
            LOG_MISS_MATCH.warn("Cost mismatch - Mapper: {}, stop-arrivals: {}, path: {}", new Object[]{OtpNumberFormat.formatCost(path.generalizedCost()), this.raptorCostsAsString(destArrival), path.toStringDetailed(this.stopNameResolver)});
        }
    }

    private String raptorCostsAsString(DestinationArrival<T> destArrival) {
        ArrayList<String> arrivalCosts = new ArrayList<String>();
        for (ArrivalView<T> it = destArrival; it != null; it = it.previous()) {
            arrivalCosts.add(OtpNumberFormat.formatCost(it.cost()));
        }
        return String.join((CharSequence)" ", arrivalCosts).replaceAll("\\.00", "");
    }
}

