/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria.configure;

import java.util.function.BiFunction;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.Heuristics;
import org.opentripplanner.transit.raptor.api.view.Worker;
import org.opentripplanner.transit.raptor.rangeraptor.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.McRangeRaptorWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.MultiCriteriaRoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.StopArrivals;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.heuristic.HeuristicsProvider;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.path.configure.PathConfig;
import org.opentripplanner.transit.raptor.rangeraptor.transit.SearchContext;

public class McRangeRaptorConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> context;
    private final PathConfig<T> pathConfig;
    private DestinationArrivalPaths<T> paths;

    public McRangeRaptorConfig(SearchContext<T> context) {
        this.context = context;
        this.pathConfig = new PathConfig<T>(context);
    }

    public Worker<T> createWorker(Heuristics heuristics, BiFunction<WorkerState<T>, RoutingStrategy<T>, Worker<T>> createWorker) {
        McRangeRaptorWorkerState<T> state = this.createState(heuristics);
        return createWorker.apply(state, this.createTransitWorkerStrategy(state));
    }

    private RoutingStrategy<T> createTransitWorkerStrategy(McRangeRaptorWorkerState<T> state) {
        return new MultiCriteriaRoutingStrategy<T>(state, this.context.slackProvider(), this.context.costCalculator(), this.context.debugFactory());
    }

    private McRangeRaptorWorkerState<T> createState(Heuristics heuristics) {
        return new McRangeRaptorWorkerState<T>(this.createStopArrivals(), this.createDestinationArrivalPaths(), this.createHeuristicsProvider(heuristics), this.context.costCalculator(), this.context.calculator(), this.context.lifeCycle());
    }

    private StopArrivals<T> createStopArrivals() {
        return new StopArrivals<T>(this.context.nStops(), this.context.egressPaths(), this.createDestinationArrivalPaths(), this.context.debugFactory());
    }

    private HeuristicsProvider<T> createHeuristicsProvider(Heuristics heuristics) {
        if (heuristics == null) {
            return new HeuristicsProvider();
        }
        return new HeuristicsProvider<T>(heuristics, this.context.roundProvider(), this.createDestinationArrivalPaths(), this.context.costCalculator(), this.context.debugFactory());
    }

    private DestinationArrivalPaths<T> createDestinationArrivalPaths() {
        if (this.paths == null) {
            this.paths = this.pathConfig.createDestArrivalPaths(true);
        }
        return this.paths;
    }
}

