/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals;

import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoComparator;

public abstract class AbstractStopArrival<T extends RaptorTripSchedule>
implements ArrivalView<T> {
    private final AbstractStopArrival<T> previous;
    private final int paretoRound;
    private final int stop;
    private final int arrivalTime;
    private final int travelDuration;
    private final int cost;

    public static <T extends RaptorTripSchedule> ParetoComparator<AbstractStopArrival<T>> compareArrivalTimeRoundAndCost() {
        return (l, r) -> l.arrivalTime < r.arrivalTime || l.paretoRound < r.paretoRound || l.cost < r.cost;
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<AbstractStopArrival<T>> compareArrivalTimeAndRound() {
        return (l, r) -> l.arrivalTime < r.arrivalTime || l.paretoRound < r.paretoRound;
    }

    AbstractStopArrival(AbstractStopArrival<T> previous, int paretoRoundIncrement, int stop, int arrivalTime, int cost) {
        this.previous = previous;
        this.paretoRound = previous.paretoRound + paretoRoundIncrement;
        this.stop = stop;
        this.arrivalTime = arrivalTime;
        this.travelDuration = previous.travelDuration() + (arrivalTime - previous.arrivalTime());
        this.cost = cost;
    }

    AbstractStopArrival(int stop, int departureTime, int travelDuration, int initialCost, int paretoRound) {
        this.previous = null;
        this.paretoRound = paretoRound;
        this.stop = stop;
        this.arrivalTime = departureTime + travelDuration;
        this.travelDuration = travelDuration;
        this.cost = initialCost;
    }

    @Override
    public final int round() {
        return (this.paretoRound + 1) / 2;
    }

    @Override
    public final int stop() {
        return this.stop;
    }

    @Override
    public final int arrivalTime() {
        return this.arrivalTime;
    }

    public int travelDuration() {
        return this.travelDuration;
    }

    public AbstractStopArrival<T> timeShiftNewArrivalTime(int newArrivalTime) {
        throw new UnsupportedOperationException("No accessEgress for transfer stop arrival");
    }

    final int previousStop() {
        return this.previous.stop;
    }

    @Override
    public final AbstractStopArrival<T> previous() {
        return this.previous;
    }

    @Override
    public int cost() {
        return this.cost;
    }

    public String toString() {
        return this.asString();
    }

    public final boolean equals(Object o) {
        throw new IllegalStateException("Avoid using hashCode() and equals() for this class.");
    }

    public final int hashCode() {
        throw new IllegalStateException("Avoid using hashCode() and equals() for this class.");
    }
}

