/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.BitSet;
import java.util.List;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.DebugStopArrivalsStatistics;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.StopArrivalParetoSet;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.transit.raptor.util.BitSetIterator;

public final class StopArrivals<T extends RaptorTripSchedule> {
    private final StopArrivalParetoSet<T>[] arrivals;
    private final BitSet touchedStops;
    private final DebugHandlerFactory<T> debugHandlerFactory;
    private final DebugStopArrivalsStatistics debugStats;

    public StopArrivals(int nStops, EgressPaths egressPaths, DestinationArrivalPaths<T> paths, DebugHandlerFactory<T> debugHandlerFactory) {
        this.arrivals = new StopArrivalParetoSet[nStops];
        this.touchedStops = new BitSet(nStops);
        this.debugHandlerFactory = debugHandlerFactory;
        this.debugStats = new DebugStopArrivalsStatistics(debugHandlerFactory.debugLogger());
        this.glueTogetherEgressStopWithDestinationArrivals(egressPaths, paths);
    }

    boolean updateExist() {
        return !this.touchedStops.isEmpty();
    }

    IntIterator stopsTouchedIterator() {
        return new BitSetIterator(this.touchedStops);
    }

    void addStopArrival(AbstractStopArrival<T> arrival) {
        boolean added = this.findOrCreateSet(arrival.stop()).add(arrival);
        if (added) {
            this.touchedStops.set(arrival.stop());
        }
    }

    void debugStateInfo() {
        this.debugStats.debugStatInfo(this.arrivals);
    }

    Iterable<AbstractStopArrival<T>> listArrivalsAfterMarker(int stop) {
        StopArrivalParetoSet<T> it = this.arrivals[stop];
        if (it == null) {
            return List.of();
        }
        return it.elementsAfterMarker();
    }

    void clearTouchedStopsAndSetStopMarkers() {
        IntIterator it = this.stopsTouchedIterator();
        while (it.hasNext()) {
            this.arrivals[it.next()].markAtEndOfSet();
        }
        this.touchedStops.clear();
    }

    private StopArrivalParetoSet<T> findOrCreateSet(int stop) {
        if (this.arrivals[stop] == null) {
            this.arrivals[stop] = StopArrivalParetoSet.createStopArrivalSet(stop, this.debugHandlerFactory);
        }
        return this.arrivals[stop];
    }

    private void glueTogetherEgressStopWithDestinationArrivals(EgressPaths egressPaths, DestinationArrivalPaths<T> paths) {
        egressPaths.byStop().forEachEntry((stop, list) -> {
            this.arrivals[stop] = StopArrivalParetoSet.createEgressStopArrivalSet(stop, list, paths, this.debugHandlerFactory);
            return true;
        });
    }
}

