/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoComparator;

public final class PatternRide<T extends RaptorTripSchedule> {
    public final AbstractStopArrival<T> prevArrival;
    public final int boardStopIndex;
    public final int boardPos;
    public final int boardTime;
    public final T trip;
    public final int relativeCost;
    public final int boardCost;
    private final int tripSortIndex;

    public PatternRide(AbstractStopArrival<T> prevArrival, int boardStopIndex, int boardPos, int boardTime, int boardCost, int relativeCost, T trip) {
        this.prevArrival = prevArrival;
        this.boardStopIndex = boardStopIndex;
        this.boardPos = boardPos;
        this.boardTime = boardTime;
        this.trip = trip;
        this.boardCost = boardCost;
        this.relativeCost = relativeCost;
        this.tripSortIndex = trip.tripSortIndex();
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<PatternRide<T>> paretoComparatorRelativeCost() {
        return (l, r) -> l.tripSortIndex != r.tripSortIndex || l.relativeCost < r.relativeCost;
    }

    public String toString() {
        return ToStringBuilder.of(PatternRide.class).addNum("prevArrival", this.prevArrival.stop()).addNum("boardStop", this.boardStopIndex).addNum("boardPos", this.boardPos).addServiceTime("boardTime", this.boardTime).addObj("trip", this.trip).addNum("boardCost", this.boardCost).addNum("relativeCost", this.relativeCost).addNum("tripSortIndex", this.tripSortIndex).toString();
    }
}

