/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.function.IntConsumer;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.McRangeRaptorWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.PatternRide;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoSet;

public final class MultiCriteriaRoutingStrategy<T extends RaptorTripSchedule>
implements RoutingStrategy<T> {
    private final McRangeRaptorWorkerState<T> state;
    private final CostCalculator costCalculator;
    private final SlackProvider slackProvider;
    private final ParetoSet<PatternRide<T>> patternRides;
    private AbstractStopArrival<T> prevArrival;

    public MultiCriteriaRoutingStrategy(McRangeRaptorWorkerState<T> state, SlackProvider slackProvider, CostCalculator costCalculator, DebugHandlerFactory<T> debugHandlerFactory) {
        this.state = state;
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.patternRides = new ParetoSet(PatternRide.paretoComparatorRelativeCost(), debugHandlerFactory.paretoSetPatternRideListener());
    }

    @Override
    public void setAccessToStop(RaptorTransfer accessPath, int iterationDepartureTime, int timeDependentDepartureTime) {
        this.state.setAccessToStop(accessPath, timeDependentDepartureTime);
    }

    @Override
    public void prepareForTransitWith(RaptorTripPattern pattern) {
        this.patternRides.clear();
    }

    @Override
    public void alight(int stopIndex, int stopPos, int alightSlack) {
        for (PatternRide<T> ride : this.patternRides) {
            this.state.transitToStop(ride, stopIndex, ride.trip.arrival(stopPos), alightSlack);
        }
    }

    @Override
    public void forEachBoarding(int stopIndex, IntConsumer prevStopArrivalTimeConsumer) {
        for (AbstractStopArrival<T> prevArrival : this.state.listStopArrivalsPreviousRound(stopIndex)) {
            this.prevArrival = prevArrival;
            prevStopArrivalTimeConsumer.accept(prevArrival.arrivalTime());
        }
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        return this.prevArrival.mostResentTransitArrival();
    }

    @Override
    public void board(int stopIndex, int earliestBoardTime, RaptorTripScheduleBoardOrAlightEvent<T> boarding) {
        T trip = boarding.getTrip();
        int boardTime = boarding.getTime();
        if (this.prevArrival.arrivedByAccess()) {
            int latestArrivalTime = boardTime - this.slackProvider.boardSlack(trip.pattern());
            this.prevArrival = this.prevArrival.timeShiftNewArrivalTime(latestArrivalTime);
        }
        int boardCost = this.calculateCostAtBoardTime(this.prevArrival, boarding);
        int relativeBoardCost = boardCost + this.calculateOnTripRelativeCost(trip.transitReluctanceFactorIndex(), boardTime);
        this.patternRides.add(new PatternRide<T>(this.prevArrival, stopIndex, boarding.getStopPositionInPattern(), boardTime, boardCost, relativeBoardCost, trip));
    }

    private int calculateCostAtBoardTime(AbstractStopArrival<T> prevArrival, RaptorTripScheduleBoardOrAlightEvent<T> boardEvent) {
        return prevArrival.cost() + this.costCalculator.boardingCost(prevArrival.isFirstRound(), prevArrival.arrivalTime(), boardEvent.getBoardStopIndex(), boardEvent.getTime(), (RaptorTripSchedule)boardEvent.getTrip(), boardEvent.getTransferConstraint());
    }

    private int calculateOnTripRelativeCost(int transitReluctanceIndex, int boardTime) {
        return this.costCalculator.onTripRelativeRidingCost(boardTime, transitReluctanceIndex);
    }
}

