/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.Locale;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.debug.DebugTopic;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.StopArrivalParetoSet;

class DebugStopArrivalsStatistics {
    private final DebugLogger debugLogger;
    private static boolean firstTime = true;

    DebugStopArrivalsStatistics(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
    }

    void debugStatInfo(StopArrivalParetoSet<?>[] stops) {
        if (!this.debugLogger.isEnabled(DebugTopic.STOP_ARRIVALS_STATISTICS)) {
            return;
        }
        long total = 0L;
        long arrayLen = 0L;
        long numOfStops = 0L;
        int max = 0;
        for (StopArrivalParetoSet<?> stop : stops) {
            if (stop == null) continue;
            ++numOfStops;
            total += (long)stop.size();
            max = Math.max(stop.size(), max);
            arrayLen += (long)stop.internalArrayLength();
        }
        double avg = (double)total / (double)numOfStops;
        double arrayLenAvg = (double)arrayLen / (double)numOfStops;
        if (firstTime) {
            this.debugLogger.debug(DebugTopic.STOP_ARRIVALS_STATISTICS, "Debug stop arrivals statistics. The number logged are: \n  - For each stop the number of arrivals logged with:\n    - Avarage number of arrivals for stops visited.\n    - The maximum numbers of arriavels for any stop.\n    - The total number of stop arrivals.\n  - The capasity(array length) used.\n    - The avarage array length for stops visited.\n    - The total array length allocated.\n  - The number of stops:\n    - The number of stops visited.\n    - The total number of stops.\n");
            firstTime = false;
        }
        this.debugLogger.debug(DebugTopic.STOP_ARRIVALS_STATISTICS, "Arrivals %5s %3s %6s (avg/max/tot)  -  Array Length: %5s %5s (avg/tot) -  Stops: %5s %5s (visited/tot)", DebugStopArrivalsStatistics.toStr(avg), DebugStopArrivalsStatistics.toStr(max), DebugStopArrivalsStatistics.toStr(total), DebugStopArrivalsStatistics.toStr(arrayLenAvg), DebugStopArrivalsStatistics.toStr(arrayLen), DebugStopArrivalsStatistics.toStr(numOfStops), DebugStopArrivalsStatistics.toStr(stops.length));
    }

    private static String toStr(long number) {
        if (number > 1000000L) {
            return DebugStopArrivalsStatistics.toStr((double)number / 1000000.0) + "\"";
        }
        if (number > 1000L) {
            return DebugStopArrivalsStatistics.toStr((double)number / 1000.0) + "'";
        }
        return Long.toString(number);
    }

    private static String toStr(double number) {
        if (number > 10.0) {
            return String.format(Locale.ROOT, "%.0f", number);
        }
        return String.format(Locale.ROOT, "%.1f", number);
    }
}

