/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.debug;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.opentripplanner.transit.raptor.api.debug.DebugEvent;
import org.opentripplanner.transit.raptor.api.request.DebugRequest;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.view.DebugHandler;

abstract class AbstractDebugHandlerAdapter<T>
implements DebugHandler<T> {
    private final List<Integer> stops;
    private final List<Integer> path;
    private final int pathStartAtStopIndex;
    private final Consumer<DebugEvent<T>> eventListener;
    private int iterationDepartureTime = -1;

    AbstractDebugHandlerAdapter(DebugRequest debugRequest, Consumer<DebugEvent<T>> eventListener, WorkerLifeCycle lifeCycle) {
        this.stops = debugRequest.stops();
        this.path = debugRequest.path();
        this.pathStartAtStopIndex = debugRequest.debugPathFromStopIndex();
        this.eventListener = eventListener;
        lifeCycle.onSetupIteration(this::setupIteration);
    }

    @Override
    public boolean isDebug(int stop) {
        return this.stops.contains(stop) || this.isDebugTrip(stop);
    }

    @Override
    public void accept(T element) {
        if (this.isDebugStopOrTripPath(element)) {
            this.eventListener.accept(DebugEvent.accept(this.iterationDepartureTime, element));
        }
    }

    @Override
    public void reject(T element, T rejectedByElement, String reason) {
        if (this.isDebugStopOrTripPath(element)) {
            this.eventListener.accept(DebugEvent.reject(this.iterationDepartureTime, element, rejectedByElement, reason));
        }
    }

    @Override
    public void drop(T element, T droppedByElement, String reason) {
        if (this.isDebugStopOrTripPath(element)) {
            this.eventListener.accept(DebugEvent.drop(this.iterationDepartureTime, element, droppedByElement, reason));
        }
    }

    protected abstract int stop(T var1);

    protected abstract Iterable<Integer> stopsVisited(T var1);

    private void setupIteration(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }

    private boolean isDebugTrip(int stop) {
        return this.pathStartAtStopIndex <= this.path.indexOf(stop);
    }

    private boolean isDebugStopOrTripPath(T arrival) {
        return this.stops.contains(this.stop(arrival)) || this.isDebugTripPath(arrival);
    }

    private boolean isDebugTripPath(T arrival) {
        if (!this.isDebugTrip(this.stop(arrival))) {
            return false;
        }
        Iterator<Integer> stopsVisited = this.stopsVisited(arrival).iterator();
        Iterator<Integer> pathStops = this.path.iterator();
        while (stopsVisited.hasNext()) {
            Integer pathStop;
            if (!pathStops.hasNext()) {
                return false;
            }
            Integer visitedStop = stopsVisited.next();
            if (visitedStop.equals(pathStop = pathStops.next())) continue;
            return false;
        }
        return true;
    }
}

