/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.configure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.Heuristics;
import org.opentripplanner.transit.raptor.api.view.Worker;
import org.opentripplanner.transit.raptor.rangeraptor.RangeRaptorWorker;
import org.opentripplanner.transit.raptor.rangeraptor.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.debug.WorkerPerformanceTimers;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.configure.McRangeRaptorConfig;
import org.opentripplanner.transit.raptor.rangeraptor.standard.configure.StdRangeRaptorConfig;
import org.opentripplanner.transit.raptor.rangeraptor.standard.heuristics.HeuristicSearch;
import org.opentripplanner.transit.raptor.rangeraptor.transit.SearchContext;
import org.opentripplanner.transit.raptor.service.RaptorSearchWindowCalculator;
import org.opentripplanner.transit.raptor.service.RequestAlias;

public class RaptorConfig<T extends RaptorTripSchedule> {
    private final ExecutorService threadPool;
    private final RaptorTuningParameters tuningParameters;
    private final MeterRegistry registry;

    public RaptorConfig(RaptorTuningParameters tuningParameters, MeterRegistry registry) {
        this.tuningParameters = tuningParameters;
        this.threadPool = this.createNewThreadPool(tuningParameters.searchThreadPoolSize());
        this.registry = registry;
    }

    public static <T extends RaptorTripSchedule> RaptorConfig<T> defaultConfigForTest() {
        return new RaptorConfig<T>(new RaptorTuningParameters(){}, (MeterRegistry)Metrics.globalRegistry);
    }

    public SearchContext<T> context(RaptorTransitDataProvider<T> transit, RaptorRequest<T> request) {
        return new SearchContext<T>(request, this.tuningParameters, transit, new WorkerPerformanceTimers(RequestAlias.alias(request, this.isMultiThreaded()), this.registry));
    }

    public Worker<T> createStdWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        return new StdRangeRaptorConfig(context).createSearch((s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w));
    }

    public Worker<T> createMcWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request, Heuristics heuristics) {
        SearchContext<T> context = this.context(transitData, request);
        return new McRangeRaptorConfig(context).createWorker(heuristics, (s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w));
    }

    public HeuristicSearch<T> createHeuristicSearch(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        return new StdRangeRaptorConfig(context).createHeuristicSearch((s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w));
    }

    public boolean isMultiThreaded() {
        return this.threadPool != null;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public RaptorSearchWindowCalculator searchWindowCalculator() {
        return new RaptorSearchWindowCalculator(this.tuningParameters.dynamicSearchWindowCoefficients());
    }

    private Worker<T> createWorker(SearchContext<T> ctx, WorkerState<T> workerState, RoutingStrategy<T> routingStrategy) {
        return new RangeRaptorWorker<T>(workerState, routingStrategy, ctx.transit(), ctx.slackProvider(), ctx.accessPaths(), ctx.roundProvider(), ctx.calculator(), ctx.createLifeCyclePublisher(), ctx.timers(), ctx.enableConstrainedTransfers());
    }

    @Nullable
    private ExecutorService createNewThreadPool(int size) {
        return size > 0 ? Executors.newFixedThreadPool(size) : null;
    }
}

