/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor;

import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Iterator;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTripScheduleBoardingSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorRoute;
import org.opentripplanner.transit.raptor.api.transit.RaptorTimeTable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.api.view.Worker;
import org.opentripplanner.transit.raptor.rangeraptor.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.debug.WorkerPerformanceTimers;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.RoundTracker;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.rangeraptor.workerlifecycle.LifeCycleEventPublisher;

public final class RangeRaptorWorker<T extends RaptorTripSchedule>
implements Worker<T> {
    private final RoutingStrategy<T> transitWorker;
    private final WorkerState<T> state;
    private final RoundTracker roundTracker;
    private final RaptorTransitDataProvider<T> transitData;
    private final SlackProvider slackProvider;
    private final TransitCalculator<T> calculator;
    private final WorkerPerformanceTimers timers;
    private final AccessPaths accessPaths;
    private final LifeCycleEventPublisher lifeCycle;
    private final int minNumberOfRounds;
    private final boolean enableTransferConstraints;
    private boolean inFirstIteration = true;
    private boolean hasTimeDependentAccess = false;
    private int iterationDepartureTime;

    public RangeRaptorWorker(WorkerState<T> state, RoutingStrategy<T> transitWorker, RaptorTransitDataProvider<T> transitData, SlackProvider slackProvider, AccessPaths accessPaths, RoundProvider roundProvider, TransitCalculator<T> calculator, LifeCycleEventPublisher lifeCyclePublisher, WorkerPerformanceTimers timers, boolean enableTransferConstraints) {
        this.transitWorker = transitWorker;
        this.state = state;
        this.transitData = transitData;
        this.slackProvider = slackProvider;
        this.calculator = calculator;
        this.timers = timers;
        this.accessPaths = accessPaths;
        this.minNumberOfRounds = accessPaths.calculateMaxNumberOfRides();
        this.enableTransferConstraints = enableTransferConstraints;
        this.roundTracker = (RoundTracker)roundProvider;
        this.lifeCycle = lifeCyclePublisher;
    }

    @Override
    public Collection<Path<T>> route() {
        this.timerRoute().record(() -> {
            this.lifeCycle.notifyRouteSearchStart(this.calculator.searchForward());
            this.transitData.setup();
            IntIterator it = this.calculator.rangeRaptorMinutes();
            while (it.hasNext()) {
                this.iterationDepartureTime = it.next();
                this.lifeCycle.setupIteration(this.iterationDepartureTime);
                this.runRaptorForMinute();
                this.inFirstIteration = false;
            }
        });
        return this.state.extractPaths();
    }

    private void runRaptorForMinute() {
        this.findAccessOnStreetForRound();
        while (this.hasMoreRounds()) {
            this.lifeCycle.prepareForNextRound(this.roundTracker.nextRound());
            this.findTransitForRound();
            this.findAccessOnBoardForRound();
            this.findTransfersForRound();
            this.lifeCycle.roundComplete(this.state.isDestinationReachedInCurrentRound());
            this.findAccessOnStreetForRound();
        }
        this.lifeCycle.iterationComplete();
    }

    private boolean hasMoreRounds() {
        if (this.round() < this.minNumberOfRounds) {
            return true;
        }
        return this.state.isNewRoundAvailable() && this.roundTracker.hasMoreRounds();
    }

    private void findTransitForRound() {
        this.timerByMinuteScheduleSearch().record(() -> {
            IntIterator stops = this.state.stopsTouchedPreviousRound();
            Iterator<RaptorRoute<T>> routeIterator = this.transitData.routeIterator(stops);
            while (routeIterator.hasNext()) {
                RaptorRoute<T> route = routeIterator.next();
                RaptorTripPattern pattern = route.pattern();
                RaptorTripScheduleSearch<T> tripSearch = this.createTripSearch(route.timetable());
                RaptorConstrainedTripScheduleBoardingSearch<T> txSearch = this.enableTransferConstraints ? this.calculator.transferConstraintsSearch(route) : null;
                int alightSlack = this.slackProvider.alightSlack(pattern);
                int boardSlack = this.slackProvider.boardSlack(pattern);
                this.transitWorker.prepareForTransitWith(pattern);
                IntIterator stop = this.calculator.patternStopIterator(pattern.numberOfStopsInPattern());
                while (stop.hasNext()) {
                    int stopPos = stop.next();
                    int stopIndex = pattern.stopIndex(stopPos);
                    if (this.calculator.alightingPossibleAt(pattern, stopPos)) {
                        this.transitWorker.alight(stopIndex, stopPos, alightSlack);
                    }
                    if (!this.calculator.boardingPossibleAt(pattern, stopPos)) continue;
                    this.transitWorker.forEachBoarding(stopIndex, prevArrivalTime -> {
                        boolean handled = this.boardWithConstrainedTransfer(txSearch, route.timetable(), stopIndex, stopPos, prevArrivalTime, boardSlack);
                        if (!handled) {
                            this.boardWithRegularTransfer(tripSearch, stopIndex, stopPos, prevArrivalTime, boardSlack);
                        }
                    });
                }
            }
            this.lifeCycle.transitsForRoundComplete();
        });
    }

    private void boardWithRegularTransfer(RaptorTripScheduleSearch<T> tripSearch, int stopIndex, int stopPos, int prevArrivalTime, int boardSlack) {
        int earliestBoardTime = this.earliestBoardTime(prevArrivalTime, boardSlack);
        RaptorTripScheduleBoardOrAlightEvent<T> result = tripSearch.search(earliestBoardTime, stopPos, this.transitWorker.onTripIndex());
        if (result != null) {
            this.transitWorker.board(stopIndex, earliestBoardTime, result);
        } else {
            this.transitWorker.boardSameTrip(earliestBoardTime, stopPos, stopIndex);
        }
    }

    private boolean boardWithConstrainedTransfer(RaptorConstrainedTripScheduleBoardingSearch<T> txSearch, RaptorTimeTable<T> targetTimetable, int targetStopIndex, int targetStopPos, int prevArrivalTime, int boardSlack) {
        if (!this.enableTransferConstraints) {
            return false;
        }
        if (!txSearch.transferExist(targetStopPos)) {
            return false;
        }
        TransitArrival<T> sourceStopArrival = this.transitWorker.previousTransit(targetStopIndex);
        if (sourceStopArrival == null) {
            return false;
        }
        int prevTransitStopArrivalTime = sourceStopArrival.arrivalTime();
        int prevTransitArrivalTime = this.calculator.minusDuration(prevTransitStopArrivalTime, this.slackProvider.alightSlack(sourceStopArrival.trip().pattern()));
        int earliestBoardTime = this.earliestBoardTime(prevArrivalTime, boardSlack);
        RaptorTripScheduleBoardOrAlightEvent<T> result = txSearch.find(targetTimetable, sourceStopArrival.trip(), sourceStopArrival.stop(), prevTransitArrivalTime, earliestBoardTime);
        if (result == null) {
            return false;
        }
        RaptorTransferConstraint constraint = result.getTransferConstraint();
        if (constraint.isNotAllowed()) {
            return true;
        }
        this.transitWorker.board(targetStopIndex, result.getEarliestBoardTimeForConstrainedTransfer(), result);
        return true;
    }

    private void findTransfersForRound() {
        this.timerByMinuteTransfers().record(() -> {
            IntIterator it = this.state.stopsTouchedByTransitCurrentRound();
            while (it.hasNext()) {
                int fromStop = it.next();
                this.state.transferToStops(fromStop, this.calculator.getTransfers(this.transitData, fromStop));
            }
            this.lifeCycle.transfersForRoundComplete();
        });
    }

    private RaptorTripScheduleSearch<T> createTripSearch(RaptorTimeTable<T> timeTable) {
        if (!this.inFirstIteration && this.roundTracker.isFirstRound() && !this.hasTimeDependentAccess) {
            return this.calculator.createExactTripSearch(timeTable);
        }
        return this.calculator.createTripSearch(timeTable);
    }

    private void findAccessOnStreetForRound() {
        this.addAccessPaths((Collection)this.accessPaths.arrivedOnStreetByNumOfRides().get(this.round()));
    }

    private void findAccessOnBoardForRound() {
        this.addAccessPaths((Collection)this.accessPaths.arrivedOnBoardByNumOfRides().get(this.round()));
    }

    private void addAccessPaths(Collection<RaptorTransfer> accessPaths) {
        if (accessPaths == null) {
            return;
        }
        for (RaptorTransfer it : accessPaths) {
            int timeDependentDepartureTime = this.calculator.departureTime(it, this.iterationDepartureTime);
            if (timeDependentDepartureTime == -1) continue;
            if (timeDependentDepartureTime != this.iterationDepartureTime) {
                this.hasTimeDependentAccess = true;
            }
            this.transitWorker.setAccessToStop(it, this.iterationDepartureTime, timeDependentDepartureTime);
        }
    }

    private int round() {
        return this.roundTracker.round();
    }

    private int earliestBoardTime(int prevArrivalTime, int boardSlack) {
        return this.calculator.plusDuration(prevArrivalTime, boardSlack);
    }

    private Timer timerRoute() {
        return this.timers.timerRoute();
    }

    private Timer timerByMinuteScheduleSearch() {
        return this.timers.timerByMinuteScheduleSearch();
    }

    private Timer timerByMinuteTransfers() {
        return this.timers.timerByMinuteTransfers();
    }
}

