/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;

public class SearchParams {
    public static final int TIME_NOT_SET = -9999999;
    public static final int NOT_SET = -1;
    private final int earliestDepartureTime;
    private final int latestArrivalTime;
    private final int searchWindowInSeconds;
    private final boolean preferLateArrival;
    private final int numberOfAdditionalTransfers;
    private final int maxNumberOfTransfers;
    private final double relaxCostAtDestination;
    private final boolean timetableEnabled;
    private final boolean constrainedTransfersEnabled;
    private final Collection<RaptorTransfer> accessPaths;
    private final Collection<RaptorTransfer> egressPaths;

    private SearchParams() {
        this.earliestDepartureTime = -9999999;
        this.latestArrivalTime = -9999999;
        this.searchWindowInSeconds = -1;
        this.preferLateArrival = false;
        this.numberOfAdditionalTransfers = 5;
        this.maxNumberOfTransfers = -1;
        this.relaxCostAtDestination = -1.0;
        this.timetableEnabled = false;
        this.constrainedTransfersEnabled = false;
        this.accessPaths = List.of();
        this.egressPaths = List.of();
    }

    SearchParams(SearchParamsBuilder<?> builder) {
        this.earliestDepartureTime = builder.earliestDepartureTime();
        this.latestArrivalTime = builder.latestArrivalTime();
        this.searchWindowInSeconds = builder.searchWindowInSeconds();
        this.preferLateArrival = builder.preferLateArrival();
        this.numberOfAdditionalTransfers = builder.numberOfAdditionalTransfers();
        this.maxNumberOfTransfers = builder.maxNumberOfTransfers();
        this.relaxCostAtDestination = builder.relaxCostAtDestination();
        this.timetableEnabled = builder.timetableEnabled();
        this.constrainedTransfersEnabled = builder.constrainedTransfersEnabled();
        this.accessPaths = List.copyOf(builder.accessPaths());
        this.egressPaths = List.copyOf(builder.egressPaths());
    }

    static SearchParams defaults() {
        return new SearchParams();
    }

    public int earliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public boolean isEarliestDepartureTimeSet() {
        return this.earliestDepartureTime != -9999999;
    }

    public int latestArrivalTime() {
        return this.latestArrivalTime;
    }

    public boolean isLatestArrivalTimeSet() {
        return this.latestArrivalTime != -9999999;
    }

    public int searchWindowInSeconds() {
        return this.searchWindowInSeconds;
    }

    public boolean isSearchWindowSet() {
        return this.searchWindowInSeconds != -1;
    }

    public boolean searchOneIterationOnly() {
        return this.searchWindowInSeconds == 0;
    }

    public boolean preferLateArrival() {
        return this.preferLateArrival;
    }

    public int numberOfAdditionalTransfers() {
        return this.numberOfAdditionalTransfers;
    }

    public int maxNumberOfTransfers() {
        return this.maxNumberOfTransfers;
    }

    public boolean isMaxNumberOfTransfersSet() {
        return this.maxNumberOfTransfers != -1;
    }

    public double relaxCostAtDestination() {
        return this.relaxCostAtDestination;
    }

    public boolean timetableEnabled() {
        return this.timetableEnabled;
    }

    public boolean constrainedTransfersEnabled() {
        return this.constrainedTransfersEnabled;
    }

    public Collection<RaptorTransfer> accessPaths() {
        return this.accessPaths;
    }

    public Collection<RaptorTransfer> egressPaths() {
        return this.egressPaths;
    }

    public int getAccessEgressMaxDurationSeconds() {
        return Math.max(this.accessPaths.stream().mapToInt(RaptorTransfer::durationInSeconds).max().orElse(0), this.egressPaths.stream().mapToInt(RaptorTransfer::durationInSeconds).max().orElse(0));
    }

    public String toString() {
        return ToStringBuilder.of(SearchParams.class).addServiceTime("earliestDepartureTime", this.earliestDepartureTime, -9999999).addServiceTime("latestArrivalTime", this.latestArrivalTime, -9999999).addDurationSec("searchWindow", this.searchWindowInSeconds).addBoolIfTrue("departAsLateAsPossible", this.preferLateArrival).addNum("numberOfAdditionalTransfers", this.numberOfAdditionalTransfers).addCollection("accessPaths", this.accessPaths, 5).addCollection("egressPaths", this.egressPaths, 5).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParams that = (SearchParams)o;
        return this.earliestDepartureTime == that.earliestDepartureTime && this.latestArrivalTime == that.latestArrivalTime && this.searchWindowInSeconds == that.searchWindowInSeconds && this.preferLateArrival == that.preferLateArrival && this.numberOfAdditionalTransfers == that.numberOfAdditionalTransfers && this.accessPaths.equals(that.accessPaths) && this.egressPaths.equals(that.egressPaths);
    }

    public int hashCode() {
        return Objects.hash(this.earliestDepartureTime, this.latestArrivalTime, this.searchWindowInSeconds, this.preferLateArrival, this.accessPaths, this.egressPaths, this.numberOfAdditionalTransfers);
    }

    void verify() {
        RaptorRequest.assertProperty(this.earliestDepartureTime != -9999999 || this.latestArrivalTime != -9999999, "'earliestDepartureTime' or 'latestArrivalTime' is required.");
        RaptorRequest.assertProperty(!this.accessPaths.isEmpty(), "At least one 'accessPath' is required.");
        RaptorRequest.assertProperty(!this.egressPaths.isEmpty(), "At least one 'egressPath' is required.");
        RaptorRequest.assertProperty(!this.preferLateArrival || this.latestArrivalTime != -9999999, "The 'latestArrivalTime' is required when 'departAsLateAsPossible' is set.");
        RaptorRequest.assertProperty(!this.preferLateArrival || !this.timetableEnabled, "The 'departAsLateAsPossible' is not allowed together with 'timetableEnabled'.");
    }
}

