/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.opentripplanner.transit.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.Optimization;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.SearchDirection;
import org.opentripplanner.transit.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public class RaptorRequestBuilder<T extends RaptorTripSchedule> {
    private final SearchParamsBuilder<T> searchParams;
    private SearchDirection searchDirection;
    private RaptorSlackProvider slackProvider;
    private RaptorProfile profile;
    private final Set<Optimization> optimizations = EnumSet.noneOf(Optimization.class);
    private final DebugRequestBuilder debug;

    public RaptorRequestBuilder() {
        this(RaptorRequest.defaults());
    }

    RaptorRequestBuilder(RaptorRequest<T> defaults) {
        this.searchParams = new SearchParamsBuilder(this, defaults.searchParams());
        this.searchDirection = defaults.searchDirection();
        this.slackProvider = defaults.slackProvider();
        this.profile = defaults.profile();
        this.optimizations.addAll(defaults.optimizations());
        this.debug = new DebugRequestBuilder(defaults.debug());
    }

    public SearchParamsBuilder<T> searchParams() {
        return this.searchParams;
    }

    public RaptorProfile profile() {
        return this.profile;
    }

    public RaptorRequestBuilder<T> profile(RaptorProfile profile) {
        this.profile = profile;
        return this;
    }

    public SearchDirection searchDirection() {
        return this.searchDirection;
    }

    public RaptorRequestBuilder<T> searchDirection(SearchDirection searchDirection) {
        this.searchDirection = searchDirection;
        return this;
    }

    public RaptorSlackProvider slackProvider() {
        return this.slackProvider;
    }

    public void slackProvider(@NotNull RaptorSlackProvider slackProvider) {
        this.slackProvider = slackProvider;
    }

    public Collection<Optimization> optimizations() {
        return this.optimizations;
    }

    public RaptorRequestBuilder<T> enableOptimization(Optimization optimization) {
        this.optimizations.add(optimization);
        return this;
    }

    public RaptorRequestBuilder<T> clearOptimizations() {
        this.optimizations.clear();
        return this;
    }

    public RaptorRequestBuilder<T> disableOptimization(Optimization optimization) {
        this.optimizations.remove((Object)optimization);
        return this;
    }

    public DebugRequestBuilder debug() {
        return this.debug;
    }

    public RaptorRequest<T> build() {
        return new RaptorRequest(this);
    }
}

