/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.transit.raptor.api.debug.DebugEvent;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.PatternRide;

public class DebugRequest {
    private final List<Integer> stops;
    private final List<Integer> path;
    private final int debugPathFromStopIndex;
    private final Consumer<DebugEvent<ArrivalView<?>>> stopArrivalListener;
    private final Consumer<DebugEvent<PatternRide<?>>> patternRideDebugListener;
    private final Consumer<DebugEvent<Path<?>>> pathFilteringListener;
    private final DebugLogger logger;

    static <T extends RaptorTripSchedule> DebugRequest defaults() {
        return new DebugRequest();
    }

    private DebugRequest() {
        this.stops = Collections.emptyList();
        this.path = Collections.emptyList();
        this.debugPathFromStopIndex = 0;
        this.stopArrivalListener = null;
        this.patternRideDebugListener = null;
        this.pathFilteringListener = null;
        this.logger = (topic, message) -> {};
    }

    DebugRequest(DebugRequestBuilder builder) {
        this.stops = List.copyOf(builder.stops());
        this.path = List.copyOf(builder.path());
        this.debugPathFromStopIndex = builder.debugPathFromStopIndex();
        this.stopArrivalListener = builder.stopArrivalListener();
        this.patternRideDebugListener = builder.patternRideDebugListener();
        this.pathFilteringListener = builder.pathFilteringListener();
        this.logger = builder.logger();
    }

    public List<Integer> stops() {
        return this.stops;
    }

    public List<Integer> path() {
        return this.path;
    }

    public int debugPathFromStopIndex() {
        return this.debugPathFromStopIndex;
    }

    public Consumer<DebugEvent<ArrivalView<?>>> stopArrivalListener() {
        return this.stopArrivalListener;
    }

    public Consumer<DebugEvent<PatternRide<?>>> patternRideDebugListener() {
        return this.patternRideDebugListener;
    }

    public Consumer<DebugEvent<Path<?>>> pathFilteringListener() {
        return this.pathFilteringListener;
    }

    public DebugLogger logger() {
        return this.logger;
    }

    public String toString() {
        return "DebugRequest{stops=" + this.stops + ", path=" + this.path + ", startAtStopIndex=" + this.debugPathFromStopIndex + ", stopArrivalListener=" + DebugRequest.enabled(this.stopArrivalListener) + ", pathFilteringListener=" + DebugRequest.enabled(this.pathFilteringListener) + ", logger=" + DebugRequest.enabled(this.logger) + "}";
    }

    private static String enabled(Object obj) {
        return obj == null ? "null" : "enabled";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugRequest that = (DebugRequest)o;
        return this.debugPathFromStopIndex == that.debugPathFromStopIndex && Objects.equals(this.stops, that.stops) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.stops, this.path, this.debugPathFromStopIndex);
    }
}

