/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.EgressPathLeg;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.path.TransferPathLeg;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.util.PathStringBuilder;

public class PathBuilderLeg<T extends RaptorTripSchedule> {
    private static final int NOT_SET = -999999999;
    private MyLeg leg;
    private int fromTime = -999999999;
    private int toTime = -999999999;
    private PathBuilderLeg<T> prev = null;
    private PathBuilderLeg<T> next = null;

    private PathBuilderLeg(PathBuilderLeg<T> other) {
        this.fromTime = other.fromTime;
        this.toTime = other.toTime;
        this.leg = other.leg;
        if (other.next != null) {
            this.next = new PathBuilderLeg<T>(other.next);
            this.next.prev = this;
        }
    }

    private PathBuilderLeg(MyLeg leg) {
        this.leg = leg;
        if (leg.isTransit()) {
            MyTransitLeg transit = (MyTransitLeg)leg;
            this.fromTime = transit.fromTime();
            this.toTime = transit.toTime();
        }
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> accessLeg(RaptorTransfer access) {
        return new PathBuilderLeg<T>(new MyAccessLeg(access));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transferLeg(RaptorTransfer transfer, int toStop) {
        return new PathBuilderLeg<T>(new MyTransferLeg(transfer, toStop));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transitLeg(T trip, BoardAndAlightTime boardAndAlightTime) {
        return PathBuilderLeg.transitLeg(trip, boardAndAlightTime, null);
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transitLeg(T trip, BoardAndAlightTime boardAndAlightTime, @Nullable RaptorConstrainedTransfer txConstrainedAfterLeg) {
        return new PathBuilderLeg<T>(new MyTransitLeg<T>(trip, boardAndAlightTime, txConstrainedAfterLeg));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> egress(RaptorTransfer egress) {
        return new PathBuilderLeg<T>(new MyEgressLeg(egress));
    }

    public int fromTime() {
        return this.fromTime;
    }

    public int fromStop() {
        return this.prev.toStop();
    }

    public int fromStopPos() {
        return this.asTransitLeg().fromStopPos();
    }

    public int toTime() {
        return this.toTime;
    }

    public int toStop() {
        return this.leg.toStop();
    }

    public int toStopPos() {
        return this.asTransitLeg().toStopPos();
    }

    private void setTime(int fromTime, int toTime) {
        this.fromTime = fromTime;
        this.toTime = toTime;
    }

    public int durationInSec() {
        return this.toTime - this.fromTime;
    }

    @Nullable
    public RaptorConstrainedTransfer constrainedTransferAfterLeg() {
        return this.isTransit() ? this.asTransitLeg().constrainedTransferAfterLeg : null;
    }

    public void setConstrainedTransferAfterLeg(@Nullable RaptorConstrainedTransfer constrainedTransferAfterLeg) {
        MyTransitLeg<T> old = this.asTransitLeg();
        this.leg = new MyTransitLeg(old.trip, old.boardAndAlightTime, constrainedTransferAfterLeg);
    }

    public boolean isAccess() {
        return this.leg.isAccess();
    }

    private boolean isAccessWithoutRides() {
        return this.isAccess() && this.hasNoRides();
    }

    public boolean hasRides() {
        return this.isTransit() || ((MyStreetLeg)this.leg).streetPath.hasRides();
    }

    public boolean hasNoRides() {
        return !this.hasRides();
    }

    public boolean isTransit() {
        return this.leg.isTransit();
    }

    public boolean isTransfer() {
        return this.leg.isTransfer();
    }

    public boolean isEgress() {
        return this.leg.isEgress();
    }

    private MyAccessLeg asAccessLeg() {
        return (MyAccessLeg)this.leg;
    }

    private MyTransferLeg asTransferLeg() {
        return (MyTransferLeg)this.leg;
    }

    private MyTransitLeg<T> asTransitLeg() {
        return (MyTransitLeg)this.leg;
    }

    private MyEgressLeg asEgressLeg() {
        return (MyEgressLeg)this.leg;
    }

    public T trip() {
        return this.asTransitLeg().trip;
    }

    PathBuilderLeg<T> prev() {
        return this.prev;
    }

    void setPrev(PathBuilderLeg<T> prev) {
        this.prev = prev;
    }

    public PathBuilderLeg<T> next() {
        return this.next;
    }

    void setNext(PathBuilderLeg<T> next) {
        this.next = next;
    }

    @Nullable
    PathBuilderLeg<T> prevTransitLeg() {
        PathBuilderLeg<T> it = this.prev();
        if (it == null) {
            return null;
        }
        if (it.isTransfer()) {
            it = it.prev();
        }
        if (it == null) {
            return null;
        }
        return it.isTransit() ? it : null;
    }

    @Nullable
    public PathBuilderLeg<T> nextTransitLeg() {
        return this.next(PathBuilderLeg::isTransit);
    }

    @Nullable
    PathBuilderLeg<T> next(Predicate<PathBuilderLeg<T>> test) {
        PathBuilderLeg<T> it;
        for (it = this.next(); it != null && !test.test(it); it = it.next()) {
        }
        return it;
    }

    public String toString() {
        return this.leg.toString();
    }

    public void toString(PathStringBuilder builder) {
        this.leg.addToString(builder);
    }

    PathBuilderLeg<T> mutate() {
        return new PathBuilderLeg<T>(this);
    }

    public void timeShiftThisAndNextLeg(RaptorSlackProvider slackProvider) {
        if (this.isAccess()) {
            this.timeShiftAccessTime(slackProvider);
        }
        if (this.next != null) {
            if (this.next.isTransfer()) {
                this.next.timeShiftTransferTime(slackProvider);
            } else if (this.next.isEgress()) {
                this.next.timeShiftEgressTime(slackProvider);
            }
        }
    }

    public int generalizedCost(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        if (this.isAccess()) {
            return this.asAccessLeg().streetPath.generalizedCost();
        }
        if (this.isTransfer()) {
            return this.asTransferLeg().streetPath.generalizedCost();
        }
        if (this.isTransit()) {
            return this.transitCost(costCalculator, slackProvider);
        }
        if (this.isEgress()) {
            return this.egressCost(costCalculator, slackProvider);
        }
        throw new IllegalStateException("Unknown leg type: " + this);
    }

    public void changeBoardingPosition(int stopPosition) {
        if (stopPosition == this.fromStopPos()) {
            return;
        }
        MyTransitLeg<T> old = this.asTransitLeg();
        BoardAndAlightTime boardAndAlightTime = new BoardAndAlightTime((RaptorTripSchedule)old.trip, stopPosition, old.boardAndAlightTime.alightStopPos());
        this.leg = new MyTransitLeg(old.trip, boardAndAlightTime, old.constrainedTransferAfterLeg);
        this.fromTime = boardAndAlightTime.boardTime();
    }

    AccessPathLeg<T> createAccessPathLeg(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        RaptorTransfer accessPath = this.asAccessLeg().streetPath;
        int cost = PathBuilderLeg.cost(costCalculator, accessPath);
        return new AccessPathLeg<T>(accessPath, this.fromTime, this.toTime, cost, nextLeg);
    }

    private PathLeg<T> createPathLeg(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        if (this.isAccess()) {
            return this.createAccessPathLeg(costCalculator, slackProvider);
        }
        if (this.isTransit()) {
            return this.createTransitPathLeg(costCalculator, slackProvider);
        }
        if (this.isTransfer()) {
            return this.createTransferPathLeg(costCalculator, slackProvider);
        }
        if (this.isEgress()) {
            return this.createEgressPathLeg(costCalculator, slackProvider);
        }
        throw new IllegalStateException("Unknown leg type: " + this);
    }

    private TransferPathLeg<T> createTransferPathLeg(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        RaptorTransfer streetPath = this.asTransferLeg().streetPath;
        int cost = PathBuilderLeg.cost(costCalculator, streetPath);
        return new TransferPathLeg<T>(this.fromStop(), this.fromTime, this.toTime, cost, streetPath, nextLeg);
    }

    private TransitPathLeg<T> createTransitPathLeg(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        MyTransitLeg<T> leg = this.asTransitLeg();
        int cost = this.transitCost(costCalculator, slackProvider);
        return new TransitPathLeg(leg.trip, leg.boardAndAlightTime, leg.constrainedTransferAfterLeg, cost, nextLeg);
    }

    private EgressPathLeg<T> createEgressPathLeg(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        int cost = this.egressCost(costCalculator, slackProvider);
        return new EgressPathLeg(this.asEgressLeg().streetPath, this.fromTime, this.toTime, cost);
    }

    private int stopArrivalTime(RaptorSlackProvider slackProvider) {
        if (!this.isTransit()) {
            return this.toTime;
        }
        return this.toTime + slackProvider.alightSlack(this.asTransitLeg().trip.pattern());
    }

    public int waitTimeBeforeNextTransitIncludingSlack() {
        if (this.next.hasRides()) {
            return this.waitTimeBeforeNextLegIncludingSlack();
        }
        return this.waitTimeBeforeNextLegIncludingSlack() + this.next.waitTimeBeforeNextLegIncludingSlack();
    }

    private int waitTimeAfterPrevStopArrival(RaptorSlackProvider slackProvider) {
        return this.fromTime - this.prev.stopArrivalTime(slackProvider);
    }

    private int waitTimeBeforeNextLegIncludingSlack() {
        return this.next.fromTime - this.toTime;
    }

    private int transitStopArrivalTimeBefore(RaptorSlackProvider slackProvider, boolean withTransferSlack) {
        MyTransitLeg<T> leg = this.asTransitLeg();
        int slack = slackProvider.boardSlack(leg.trip.pattern()) + (withTransferSlack ? slackProvider.transferSlack() : 0);
        return leg.fromTime() - slack;
    }

    private void timeShiftAccessTime(RaptorSlackProvider slackProvider) {
        RaptorTransfer accessPath = this.asAccessLeg().streetPath;
        PathBuilderLeg<T> nextTransitLeg = this.nextTransitLeg();
        int newToTime = nextTransitLeg.transitStopArrivalTimeBefore(slackProvider, this.hasRides());
        if (this.next.isTransfer()) {
            newToTime -= this.next.asTransferLeg().streetPath.durationInSeconds();
        }
        newToTime = accessPath.latestArrivalTime(newToTime);
        this.setTime(newToTime - accessPath.durationInSeconds(), newToTime);
    }

    private void timeShiftTransferTime(RaptorSlackProvider slackProvider) {
        int newFromTime;
        if (this.prev.isTransit()) {
            newFromTime = this.prev.toTime() + slackProvider.alightSlack(this.prev.asTransitLeg().trip.pattern());
        } else if (this.prev.isAccess()) {
            newFromTime = this.prev.toTime();
        } else {
            throw new IllegalStateException("Unexpected leg type before TransferLeg: " + this);
        }
        this.setTime(newFromTime, newFromTime + this.asTransferLeg().streetPath.durationInSeconds());
    }

    private void timeShiftEgressTime(RaptorSlackProvider slackProvider) {
        RaptorTransfer egressPath = this.asEgressLeg().streetPath;
        int newFromTime = this.prev.stopArrivalTime(slackProvider);
        if (egressPath.hasRides()) {
            newFromTime += slackProvider.transferSlack();
        }
        newFromTime = egressPath.earliestDepartureTime(newFromTime);
        this.setTime(newFromTime, newFromTime + egressPath.durationInSeconds());
    }

    private int transitCost(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        MyTransitLeg<T> leg = this.asTransitLeg();
        int prevStopArrivalTime = this.prev == null ? this.fromTime : this.prev.stopArrivalTime(slackProvider);
        PathBuilderLeg<T> prevTransit = this.prevTransitLeg();
        RaptorConstrainedTransfer txBeforeLeg = prevTransit == null ? null : prevTransit.constrainedTransferAfterLeg();
        RaptorTransferConstraint transferConstraint = txBeforeLeg == null ? RaptorTransferConstraint.REGULAR_TRANSFER : txBeforeLeg.getTransferConstraint();
        boolean firstBoarding = this.prev != null && this.prev.isAccessWithoutRides();
        int boardCost = costCalculator.boardingCost(firstBoarding, prevStopArrivalTime, leg.fromStop(), this.fromTime, (RaptorTripSchedule)this.trip(), transferConstraint);
        return costCalculator.transitArrivalCost(boardCost, slackProvider.alightSlack(leg.trip.pattern()), this.durationInSec(), leg.trip.transitReluctanceFactorIndex(), this.toStop());
    }

    private int egressCost(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        RaptorTransfer egressPath = this.asEgressLeg().streetPath;
        int egressCost = costCalculator.costEgress(egressPath);
        if (this.prev == null) {
            return egressCost;
        }
        int waitCost = costCalculator.waitCost(this.waitTimeAfterPrevStopArrival(slackProvider));
        return waitCost + egressCost;
    }

    private static int cost(CostCalculator costCalculator, RaptorTransfer streetPath) {
        return costCalculator != null ? streetPath.generalizedCost() : 0;
    }

    private static class MyEgressLeg
    extends MyStreetLeg {
        MyEgressLeg(RaptorTransfer streetPath) {
            super(streetPath);
        }

        @Override
        public boolean isEgress() {
            return true;
        }

        @Override
        public int toStop() {
            throw new IllegalStateException("Egress leg have no toStop");
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.accessEgress(this.streetPath);
        }
    }

    private static class MyTransitLeg<T extends RaptorTripSchedule>
    implements MyLeg {
        final T trip;
        final BoardAndAlightTime boardAndAlightTime;
        @Nullable
        private final RaptorConstrainedTransfer constrainedTransferAfterLeg;

        private MyTransitLeg(T trip, BoardAndAlightTime boardAndAlightTime, RaptorConstrainedTransfer constrainedTransferAfterLeg) {
            this.trip = trip;
            this.boardAndAlightTime = boardAndAlightTime;
            this.constrainedTransferAfterLeg = constrainedTransferAfterLeg;
        }

        @Override
        public boolean isTransit() {
            return true;
        }

        public int fromStop() {
            return this.trip.pattern().stopIndex(this.boardAndAlightTime.boardStopPos());
        }

        public int fromStopPos() {
            return this.boardAndAlightTime.boardStopPos();
        }

        public int fromTime() {
            return this.boardAndAlightTime.boardTime();
        }

        @Override
        public int toStop() {
            return this.trip.pattern().stopIndex(this.boardAndAlightTime.alightStopPos());
        }

        public int toStopPos() {
            return this.boardAndAlightTime.alightStopPos();
        }

        public int toTime() {
            return this.boardAndAlightTime.alightTime();
        }

        public final String toString() {
            return this.addToString(new PathStringBuilder(null)).toString();
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.transit(this.trip.pattern().debugInfo(), this.fromTime(), this.toTime()).sep().stop(this.toStop()).sep();
        }
    }

    private static class MyTransferLeg
    extends MyStreetLeg {
        final int toStop;

        MyTransferLeg(RaptorTransfer streetPath, int toStop) {
            super(streetPath);
            this.toStop = toStop;
        }

        @Override
        public boolean isTransfer() {
            return true;
        }

        @Override
        public int toStop() {
            return this.toStop;
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.walk(this.streetPath.durationInSeconds()).sep().stop(this.toStop()).sep();
        }
    }

    private static class MyAccessLeg
    extends MyStreetLeg {
        private MyAccessLeg(RaptorTransfer streetPath) {
            super(streetPath);
        }

        @Override
        public boolean isAccess() {
            return true;
        }

        @Override
        public int toStop() {
            return this.streetPath.stop();
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.accessEgress(this.streetPath).sep().stop(this.toStop()).sep();
        }
    }

    private static abstract class MyStreetLeg
    implements MyLeg {
        final RaptorTransfer streetPath;

        MyStreetLeg(RaptorTransfer streetPath) {
            this.streetPath = streetPath;
        }

        public final String toString() {
            return this.addToString(new PathStringBuilder(null)).toString();
        }
    }

    private static interface MyLeg {
        default public boolean isAccess() {
            return false;
        }

        default public boolean isTransit() {
            return false;
        }

        default public boolean isTransfer() {
            return false;
        }

        default public boolean isEgress() {
            return false;
        }

        public int toStop();

        public PathStringBuilder addToString(PathStringBuilder var1);
    }
}

