/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathBuilderLeg;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.util.PathStringBuilder;

public abstract class PathBuilder<T extends RaptorTripSchedule> {
    @Nullable
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    protected final RaptorSlackProvider slackProvider;
    @Nullable
    protected final CostCalculator costCalculator;
    private final RaptorStopNameResolver stopNameResolver;
    private PathBuilderLeg<T> head = null;
    private PathBuilderLeg<T> tail = null;

    protected PathBuilder(PathBuilder<T> other) {
        this(other.transferConstraintsSearch, other.slackProvider, other.costCalculator, other.stopNameResolver);
        this.head = other.head == null ? null : other.head.mutate();
        this.tail = this.head == null ? null : this.last(this.head);
    }

    protected PathBuilder(@Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, @Nullable CostCalculator costCalculator, @Nullable RaptorStopNameResolver stopNameResolver) {
        this.transferConstraintsSearch = transferConstraintsSearch;
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
    }

    public static <T extends RaptorTripSchedule> PathBuilder<T> headPathBuilder(@Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, @Nullable CostCalculator costCalculator, @Nullable RaptorStopNameResolver stopNameResolver) {
        return new HeadPathBuilder<T>(transferConstraintsSearch, slackProvider, costCalculator, stopNameResolver);
    }

    public static <T extends RaptorTripSchedule> PathBuilder<T> tailPathBuilder(RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, @Nullable CostCalculator costCalculator, @Nullable RaptorStopNameResolver stopNameResolver) {
        return new TailPathBuilder<T>(transferConstraintsSearch, slackProvider, costCalculator, stopNameResolver);
    }

    public void access(RaptorTransfer access) {
        this.add(PathBuilderLeg.accessLeg(access));
    }

    public void transit(T trip, BoardAndAlightTime times) {
        this.add(PathBuilderLeg.transitLeg(trip, times));
    }

    public void transit(T trip, BoardAndAlightTime times, RaptorConstrainedTransfer txConstrainedTransferAfter) {
        this.add(PathBuilderLeg.transitLeg(trip, times, txConstrainedTransferAfter));
    }

    public void transfer(RaptorTransfer transfer, int toStop) {
        this.add(PathBuilderLeg.transferLeg(transfer, toStop));
    }

    public void egress(RaptorTransfer egress) {
        this.add(PathBuilderLeg.egress(egress));
    }

    public Path<T> build(int iterationDepartureTime) {
        this.updateAggregatedFields();
        return new Path<T>(iterationDepartureTime, this.createPathLegs(this.costCalculator, this.slackProvider));
    }

    public String toString() {
        PathStringBuilder builder = new PathStringBuilder(this.stopNameResolver);
        this.legsAsStream().forEach(it -> it.toString(builder));
        return builder.toString();
    }

    public Stream<PathBuilderLeg<T>> legsAsStream() {
        return Stream.iterate(this.head, Objects::nonNull, PathBuilderLeg::next);
    }

    public PathBuilderLeg<T> head() {
        return this.head;
    }

    public PathBuilderLeg<T> tail() {
        return this.tail;
    }

    protected abstract void add(PathBuilderLeg<T> var1);

    protected void updateAggregatedFields() {
        this.timeShiftAllStreetLegs();
        this.insertConstrainedTransfers();
    }

    protected void addTail(PathBuilderLeg<T> newLeg) {
        if (this.head == null) {
            this.tail = newLeg;
            this.head = this.tail;
        } else {
            this.tail.setNext(newLeg);
            newLeg.setPrev(this.tail);
            this.tail = newLeg;
        }
    }

    protected void addHead(PathBuilderLeg<T> newLeg) {
        if (this.head == null) {
            this.tail = newLeg;
            this.head = this.tail;
        } else {
            newLeg.setNext(this.head);
            this.head.setPrev(newLeg);
            this.head = newLeg;
        }
    }

    private void timeShiftAllStreetLegs() {
        this.legsAsStream().forEach(leg -> leg.timeShiftThisAndNextLeg(this.slackProvider));
    }

    private void insertConstrainedTransfers() {
        if (this.transferConstraintsSearch == null) {
            return;
        }
        PathBuilderLeg<T> prev = this.head.nextTransitLeg();
        if (prev == null) {
            return;
        }
        for (PathBuilderLeg<T> curr = prev.nextTransitLeg(); curr != null; curr = curr.nextTransitLeg()) {
            this.addTransferConstraints(prev, curr);
            prev = curr;
        }
    }

    private void addTransferConstraints(PathBuilderLeg<T> from, PathBuilderLeg<T> to) {
        RaptorConstrainedTransfer tx = this.transferConstraintsSearch.findConstrainedTransfer(from.trip(), from.toStopPos(), to.trip(), to.fromStopPos());
        if (tx != null) {
            from.setConstrainedTransferAfterLeg(tx);
        }
    }

    protected AccessPathLeg<T> createPathLegs(CostCalculator costCalculator, RaptorSlackProvider slackProvider) {
        return this.head.createAccessPathLeg(costCalculator, slackProvider);
    }

    private PathBuilderLeg<T> last(PathBuilderLeg<T> head) {
        return head.next() == null ? head : this.last(head.next());
    }

    protected boolean skipCostCalc() {
        return this.costCalculator == null;
    }

    private static class TailPathBuilder<T extends RaptorTripSchedule>
    extends PathBuilder<T> {
        private TailPathBuilder(@Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, CostCalculator costCalculator, @Nullable RaptorStopNameResolver stopNameResolver) {
            super(transferConstraintsSearch, slackProvider, costCalculator, stopNameResolver);
        }

        @Override
        protected void add(PathBuilderLeg<T> newLeg) {
            this.addTail(newLeg);
        }
    }

    private static class HeadPathBuilder<T extends RaptorTripSchedule>
    extends PathBuilder<T> {
        private HeadPathBuilder(@Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, CostCalculator costCalculator, @Nullable RaptorStopNameResolver stopNameResolver) {
            super(transferConstraintsSearch, slackProvider, costCalculator, stopNameResolver);
        }

        @Override
        protected void add(PathBuilderLeg<T> newLeg) {
            this.addHead(newLeg);
        }
    }
}

