/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.EgressPathLeg;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.util.PathStringBuilder;

public class Path<T extends RaptorTripSchedule>
implements Comparable<Path<T>> {
    private final int iterationDepartureTime;
    private final int startTime;
    private final int endTime;
    private final int numberOfTransfers;
    private final int generalizedCost;
    private final AccessPathLeg<T> accessLeg;
    private final EgressPathLeg<T> egressPathLeg;

    private Path(int iterationDepartureTime, int startTime, int endTime, int numberOfTransfers, int generalizedCost) {
        this.iterationDepartureTime = iterationDepartureTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.numberOfTransfers = numberOfTransfers;
        this.generalizedCost = generalizedCost;
        this.accessLeg = null;
        this.egressPathLeg = null;
    }

    public Path(int iterationDepartureTime, AccessPathLeg<T> accessLeg, int generalizedCost) {
        this.iterationDepartureTime = iterationDepartureTime;
        this.startTime = accessLeg.fromTime();
        this.generalizedCost = generalizedCost;
        this.accessLeg = accessLeg;
        this.egressPathLeg = Path.findEgressLeg(accessLeg);
        this.numberOfTransfers = Path.countNumberOfTransfers(accessLeg, this.egressPathLeg);
        this.endTime = this.egressPathLeg.toTime();
    }

    public Path(int iterationDepartureTime, AccessPathLeg<T> accessLeg) {
        this(iterationDepartureTime, accessLeg, accessLeg.generalizedCostTotal());
    }

    protected Path(Path<T> original) {
        this(original.iterationDepartureTime, original.accessLeg, original.generalizedCost);
    }

    public static <T extends RaptorTripSchedule> Path<T> dummyPath(int iteration, int startTime, int endTime, int numberOfTransfers, int cost) {
        return new Path<T>(iteration, startTime, endTime, numberOfTransfers, cost);
    }

    public final int rangeRaptorIterationDepartureTime() {
        return this.iterationDepartureTime;
    }

    public final int startTime() {
        return this.startTime;
    }

    public final int endTime() {
        return this.endTime;
    }

    public final int durationInSeconds() {
        return this.endTime - this.startTime;
    }

    public final int numberOfTransfers() {
        return this.numberOfTransfers;
    }

    public final int numberOfTransfersExAccessEgress() {
        return Math.max(0, (int)this.transitLegs().count() - 1);
    }

    public int generalizedCost() {
        return this.generalizedCost;
    }

    public final AccessPathLeg<T> accessLeg() {
        return this.accessLeg;
    }

    public final EgressPathLeg<T> egressLeg() {
        return this.egressPathLeg;
    }

    public List<Integer> listStops() {
        return this.accessLeg.nextLeg().stream().map(PathLeg::fromStop).collect(Collectors.toList());
    }

    public int waitTime() {
        int legsTotalDuration = this.legStream().mapToInt(PathLeg::duration).sum();
        return this.durationInSeconds() - legsTotalDuration;
    }

    public Stream<PathLeg<T>> legStream() {
        return this.accessLeg.stream();
    }

    public Stream<TransitPathLeg<T>> transitLegs() {
        return this.legStream().filter(PathLeg::isTransitLeg).map(PathLeg::asTransitLeg);
    }

    public String toStringDetailed(RaptorStopNameResolver stopNameResolver) {
        return this.buildString(true, stopNameResolver, null);
    }

    public String toString(RaptorStopNameResolver stopNameTranslator) {
        return this.buildString(false, stopNameTranslator, null);
    }

    public String toString() {
        return this.buildString(false, null, null);
    }

    protected String toString(boolean detailed, RaptorStopNameResolver stopNameResolver) {
        return this.buildString(detailed, stopNameResolver, null);
    }

    protected String buildString(boolean detailed, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable Consumer<PathStringBuilder> appendToSummary) {
        Object constraintPrevLeg = null;
        PathStringBuilder buf = new PathStringBuilder(stopNameResolver);
        if (this.accessLeg != null) {
            int prevToTime = 0;
            for (PathLeg leg : this.accessLeg.iterator()) {
                if (leg == this.accessLeg) {
                    buf.accessEgress(this.accessLeg.access());
                    this.addWalkDetails(detailed, buf, leg);
                } else {
                    buf.sep().stop(leg.fromStop());
                    if (detailed) {
                        buf.duration(leg.fromTime() - prevToTime);
                        if (constraintPrevLeg != null) {
                            buf.space().append(constraintPrevLeg.toString());
                            constraintPrevLeg = null;
                        }
                    }
                    buf.sep();
                    if (leg.isTransitLeg()) {
                        TransitPathLeg transitLeg = leg.asTransitLeg();
                        buf.transit(transitLeg.trip().pattern().debugInfo(), transitLeg.fromTime(), transitLeg.toTime());
                        if (detailed) {
                            buf.duration(leg.duration());
                            buf.generalizedCostSentiSec(leg.generalizedCost());
                        }
                        if (transitLeg.getConstrainedTransferAfterLeg() != null) {
                            constraintPrevLeg = transitLeg.getConstrainedTransferAfterLeg().getTransferConstraint();
                        }
                    } else if (leg.isTransferLeg()) {
                        buf.walk(leg.duration());
                        this.addWalkDetails(detailed, buf, leg);
                    } else if (leg.isEgressLeg()) {
                        buf.accessEgress(leg.asEgressLeg().egress());
                        this.addWalkDetails(detailed, buf, leg);
                    }
                }
                prevToTime = leg.toTime();
            }
            buf.space();
        }
        buf.append("[").time(this.startTime, this.endTime).duration(this.endTime - this.startTime).space().append(this.numberOfTransfers + "tx").generalizedCostSentiSec(this.generalizedCost);
        if (appendToSummary != null) {
            appendToSummary.accept(buf);
        }
        buf.append("]");
        return buf.toString();
    }

    private void addWalkDetails(boolean detailed, PathStringBuilder buf, PathLeg<T> leg) {
        if (detailed) {
            buf.timeAndCostCentiSec(leg.fromTime(), leg.toTime(), leg.generalizedCost());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this.startTime == path.startTime && this.endTime == path.endTime && this.numberOfTransfers == path.numberOfTransfers && Objects.equals(this.accessLeg, path.accessLeg);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.numberOfTransfers, this.accessLeg);
    }

    @Override
    public int compareTo(Path<T> other) {
        int c = this.endTime - other.endTime;
        if (c != 0) {
            return c;
        }
        c = other.startTime - this.startTime;
        if (c != 0) {
            return c;
        }
        c = this.generalizedCost - other.generalizedCost;
        if (c != 0) {
            return c;
        }
        c = this.numberOfTransfers - other.numberOfTransfers;
        return c;
    }

    private static <S extends RaptorTripSchedule> EgressPathLeg<S> findEgressLeg(PathLeg<S> leg) {
        return (EgressPathLeg)leg.stream().reduce((a, b) -> b).orElseThrow();
    }

    private static <S extends RaptorTripSchedule> int countNumberOfTransfers(AccessPathLeg<S> accessLeg, EgressPathLeg<S> egressPathLeg) {
        int nAccessRides = accessLeg.access().numberOfRides();
        int nTransitRides = (int)accessLeg.stream().filter(PathLeg::isTransitLeg).map(PathLeg::asTransitLeg).filter(Predicate.not(TransitPathLeg::isStaySeatedOntoNextLeg)).count();
        int nEgressRides = egressPathLeg.egress().numberOfRides();
        return nAccessRides + nTransitRides + nEgressRides - 1;
    }
}

