/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.Objects;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public final class EgressPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final RaptorTransfer egress;
    private final int fromTime;
    private final int toTime;
    private final int generalizedCost;

    public EgressPathLeg(RaptorTransfer egress, int fromTime, int toTime, int generalizedCost) {
        this.egress = egress;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.generalizedCost = generalizedCost;
    }

    @Override
    public int fromStop() {
        return this.egress.stop();
    }

    @Override
    public int fromTime() {
        return this.fromTime;
    }

    @Override
    public int toTime() {
        return this.toTime;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    public RaptorTransfer egress() {
        return this.egress;
    }

    @Override
    public TransitPathLeg<T> nextLeg() {
        throw new UnsupportedOperationException("The egress leg is the last leg in a path. Use isEgressLeg() to identify last leg.");
    }

    @Override
    public boolean isEgressLeg() {
        return true;
    }

    public String toString() {
        return "Egress " + this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressPathLeg that = (EgressPathLeg)o;
        return this.fromStop() == that.fromStop() && this.fromTime == that.fromTime && this.toTime == that.toTime;
    }

    public int hashCode() {
        return Objects.hash(this.fromStop(), this.fromTime, this.toTime);
    }
}

