/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public final class AccessPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final RaptorTransfer access;
    private final int fromTime;
    private final int toTime;
    private final int generalizedCost;
    private final PathLeg<T> next;

    public AccessPathLeg(@Nonnull RaptorTransfer access, int fromTime, int toTime, int generalizedCost, @Nonnull PathLeg<T> next) {
        this.access = access;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.generalizedCost = generalizedCost;
        this.next = next;
    }

    @Override
    public int fromTime() {
        return this.fromTime;
    }

    @Override
    public int toStop() {
        return this.access.stop();
    }

    @Override
    public int toTime() {
        return this.toTime;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    public boolean isAccessLeg() {
        return true;
    }

    public RaptorTransfer access() {
        return this.access;
    }

    @Override
    public PathLeg<T> nextLeg() {
        return this.next;
    }

    public String toString() {
        return "Access " + this.asString(this.toStop());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessPathLeg that = (AccessPathLeg)o;
        return this.fromTime == that.fromTime && this.toStop() == that.toStop() && this.toTime == that.toTime && this.next.equals(that.next);
    }

    public int hashCode() {
        return Objects.hash(this.fromTime, this.toStop(), this.toTime, this.next);
    }
}

