/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor;

import java.util.Collection;
import java.util.stream.Collectors;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.response.RaptorResponse;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.configure.RaptorConfig;
import org.opentripplanner.transit.raptor.service.HeuristicSearchTask;
import org.opentripplanner.transit.raptor.service.RangeRaptorDynamicSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaptorService<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorService.class);
    private final RaptorConfig<T> config;

    public RaptorService(RaptorConfig<T> config) {
        this.config = config;
    }

    public RaptorResponse<T> route(RaptorRequest<T> request, RaptorTransitDataProvider<T> transitData) {
        LOG.debug("Original request: {}", request);
        RaptorResponse<T> response = request.isDynamicSearch() ? new RangeRaptorDynamicSearch<T>(this.config, transitData, request).route() : this.routeUsingStdWorker(transitData, request);
        if (LOG.isDebugEnabled()) {
            String pathsAsText = response.paths().stream().map(p -> "\t\n" + p.toString(transitData.stopNameResolver())).collect(Collectors.joining());
            LOG.debug("Result: {}", (Object)pathsAsText);
        }
        return response;
    }

    public void compareHeuristics(RaptorRequest<T> r1, RaptorRequest<T> r2, RaptorTransitDataProvider<T> transitData) {
        HeuristicSearchTask<T> fwdHeur = new HeuristicSearchTask<T>(r1, this.config, transitData);
        HeuristicSearchTask<T> revHeur = new HeuristicSearchTask<T>(r2, this.config, transitData);
        fwdHeur.forceRun();
        revHeur.forceRun();
        fwdHeur.debugCompareResult(revHeur);
    }

    public void shutdown() {
        this.config.shutdown();
    }

    private RaptorResponse<T> routeUsingStdWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        LOG.debug("Run query: {}", request);
        Collection<Path<T>> paths = this.config.createStdWorker(transitData, request).route();
        return new RaptorResponse<T>(paths, request, request);
    }
}

