/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import org.opentripplanner.ext.transmodelapi.TransmodelAPI;
import org.opentripplanner.inspector.TileRendererManager;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.transit.raptor.rangeraptor.configure.RaptorConfig;
import org.opentripplanner.updater.GraphUpdaterConfigurator;
import org.opentripplanner.util.ElevationUtils;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.WorldEnvelope;
import org.opentripplanner.visualizer.GraphVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router {
    private static final Logger LOG = LoggerFactory.getLogger(Router.class);
    public final Graph graph;
    public final RouterConfig routerConfig;
    public final RaptorConfig<TripSchedule> raptorConfig;
    public ch.qos.logback.classic.Logger requestLogger = null;
    public TileRendererManager tileRendererManager;
    public RoutingRequest defaultRoutingRequest;
    public GraphVisualizer graphVisualizer = null;

    public Router(Graph graph, RouterConfig routerConfig) {
        this.graph = graph;
        this.routerConfig = routerConfig;
        this.raptorConfig = new RaptorConfig(routerConfig.raptorTuningParameters(), (MeterRegistry)Metrics.globalRegistry);
    }

    public void startup() {
        this.tileRendererManager = new TileRendererManager(this.graph);
        this.defaultRoutingRequest = this.routerConfig.routingRequestDefaults();
        if (this.routerConfig.requestLogFile() != null) {
            this.requestLogger = Router.createLogger(this.routerConfig.requestLogFile());
            LOG.info("Logging incoming requests at '{}'", (Object)this.routerConfig.requestLogFile());
        } else {
            LOG.info("Incoming requests will not be logged.");
        }
        LOG.info("Creating transit layer for Raptor routing.");
        if (this.graph.hasTransit && this.graph.index != null) {
            this.graph.setTransitLayer(TransitLayerMapper.map(this.routerConfig.transitTuningParameters(), this.graph));
            this.graph.setRealtimeTransitLayer(new TransitLayer(this.graph.getTransitLayer()));
            this.graph.transitLayerUpdater = new TransitLayerUpdater(this.graph, this.graph.index.getServiceCodesRunningForDate());
        } else {
            LOG.warn("Cannot create Raptor data, that requires the graph to have transit data and be indexed.");
        }
        GraphUpdaterConfigurator.setupGraph(this.graph, this.routerConfig.updaterConfig());
        try {
            WorldEnvelope env = this.graph.getEnvelope();
            double lat = (env.getLowerLeftLatitude() + env.getUpperRightLatitude()) / 2.0;
            double lon = (env.getLowerLeftLongitude() + env.getUpperRightLongitude()) / 2.0;
            this.graph.ellipsoidToGeoidDifference = ElevationUtils.computeEllipsoidToGeoidDifference(lat, lon);
            LOG.info("Computed ellipsoid/geoid offset at (" + lat + ", " + lon + ") as " + this.graph.ellipsoidToGeoidDifference);
        }
        catch (Exception e) {
            LOG.error("Error computing ellipsoid/geoid difference");
        }
        if (OTPFeature.SandboxAPITransmodelApi.isOn()) {
            TransmodelAPI.setUp(this.routerConfig.transmodelApi(), this.graph, this.defaultRoutingRequest);
        }
    }

    public void shutdown() {
        GraphUpdaterConfigurator.shutdownGraph(this.graph);
    }

    private static ch.qos.logback.classic.Logger createLogger(String file) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%d{yyyy-MM-dd'T'HH:mm:ss.SSS} %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(file);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"REQ_LOG");
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(false);
        return logger;
    }

    public double streetRoutingTimeoutSeconds() {
        return this.routerConfig.streetRoutingTimeoutSeconds();
    }
}

