/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.util.WeakCollectionCleaner;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.server.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTPServer {
    private static final Logger LOG = LoggerFactory.getLogger(OTPServer.class);
    public final CommandLineParameters params;
    private final Router router;

    public OTPServer(CommandLineParameters params, Router router) {
        LOG.info("Wiring up and configuring server.");
        this.params = params;
        this.router = router;
    }

    private static void cleanupWebapp() {
        LOG.info("Web application shutdown: cleaning various stuff");
        WeakCollectionCleaner.DEFAULT.exit();
        DeferredAuthorityFactory.exit();
    }

    public Router getRouter() {
        return this.router;
    }

    public RoutingService createRoutingRequestService() {
        return new RoutingService(this.router.graph);
    }

    AbstractBinder makeBinder() {
        return new AbstractBinder(){

            protected void configure() {
                this.bind(OTPServer.this).to(OTPServer.class);
            }
        };
    }
}

