/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.jersey2.server.DefaultJerseyTagsProvider;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.micrometer.jersey2.server.MetricsApplicationEventListener;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.opentripplanner.api.common.OTPExceptionMapper;
import org.opentripplanner.api.configuration.APIEndpoints;
import org.opentripplanner.api.json.JSONObjectMapperProvider;
import org.opentripplanner.standalone.server.CorsFilter;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPApplication
extends Application {
    public final OTPServer server;

    public OTPApplication(OTPServer server) {
        this.server = server;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = Sets.newHashSet();
        classes.addAll(APIEndpoints.listAPIEndpoints());
        classes.add(CorsFilter.class);
        return classes;
    }

    public Set<Object> getSingletons() {
        HashSet singletons = Sets.newHashSet((Object[])new Object[]{new OTPExceptionMapper(), new JacksonJsonProvider(), new JSONObjectMapperProvider(), this.server.makeBinder(), this.getMetricsApplicationEventListener()});
        if (OTPFeature.ActuatorAPI.isOn()) {
            singletons.add(this.getBoundPrometheusRegistry());
        }
        return singletons;
    }

    private MetricsApplicationEventListener getMetricsApplicationEventListener() {
        return new MetricsApplicationEventListener((MeterRegistry)Metrics.globalRegistry, (JerseyTagsProvider)new DefaultJerseyTagsProvider(), "http.server.requests", true);
    }

    private AbstractBinder getBoundPrometheusRegistry() {
        final PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        Metrics.globalRegistry.add((MeterRegistry)prometheusRegistry);
        return new AbstractBinder(){

            protected void configure() {
                this.bind(prometheusRegistry).to(PrometheusMeterRegistry.class);
            }
        };
    }

    public Map<String, Object> getProperties() {
        HashMap props = Maps.newHashMap();
        props.put("jersey.config.server.tracing.type", Boolean.TRUE);
        props.put("jersey.config.disableAutoDiscovery", Boolean.TRUE);
        return props;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

