/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import org.opentripplanner.datastore.OtpDataStoreConfig;
import org.opentripplanner.standalone.config.StorageConfig;

class OtpDataStoreConfigAdapter
implements OtpDataStoreConfig {
    private final File baseDirectory;
    private final StorageConfig config;

    OtpDataStoreConfigAdapter(File baseDirectory, StorageConfig config) {
        this.baseDirectory = baseDirectory;
        this.config = config;
    }

    @Override
    public File baseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public URI reportDirectory() {
        return this.config.buildReportDir;
    }

    @Override
    public String gsCredentials() {
        return this.config.gsCredentials;
    }

    @Override
    public List<URI> osmFiles() {
        return this.config.osm;
    }

    @Override
    public List<URI> demFiles() {
        return this.config.dem;
    }

    @Override
    public List<URI> gtfsFiles() {
        return this.config.gtfs;
    }

    @Override
    public List<URI> netexFiles() {
        return this.config.netex;
    }

    @Override
    public URI graph() {
        return this.config.graph;
    }

    @Override
    public URI streetGraph() {
        return this.config.streetGraph;
    }

    @Override
    public Pattern gtfsLocalFilePattern() {
        return this.config.localFileNamePatterns.gtfs;
    }

    @Override
    public Pattern netexLocalFilePattern() {
        return this.config.localFileNamePatterns.netex;
    }

    @Override
    public Pattern osmLocalFilePattern() {
        return this.config.localFileNamePatterns.osm;
    }

    @Override
    public Pattern demLocalFilePattern() {
        return this.config.localFileNamePatterns.dem;
    }
}

