/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import org.opentripplanner.datastore.OtpDataStoreConfig;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigLoader;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.configure.OtpDataStoreConfigAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTPConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OTPConfiguration.class);
    private final CommandLineParameters cli;
    private final OtpConfig otpConfig;
    private BuildConfig buildConfig;
    private RouterConfig routerConfig;

    private OTPConfiguration(CommandLineParameters cli, ConfigLoader configLoader) {
        this.cli = cli;
        this.otpConfig = configLoader.loadOtpConfig();
        this.buildConfig = configLoader.loadBuildConfig();
        this.routerConfig = configLoader.loadRouterConfig();
    }

    public OTPConfiguration(CommandLineParameters cli) {
        this(cli, new ConfigLoader(cli.getBaseDirectory()));
    }

    public static OTPConfiguration createForTest(String configJson) {
        return new OTPConfiguration(new CommandLineParameters(), ConfigLoader.fromString(configJson));
    }

    public void updateConfigFromSerializedGraph(BuildConfig buildConfig, RouterConfig routerConfig) {
        if (this.buildConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON build configuration.");
            this.buildConfig = buildConfig;
        }
        if (this.routerConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON router configuration.");
            this.routerConfig = routerConfig;
        }
        ConfigLoader.logConfigVersion(this.otpConfig.configVersion, this.buildConfig.configVersion, this.routerConfig.getConfigVersion());
    }

    public CommandLineParameters getCli() {
        return this.cli;
    }

    public OtpConfig otpConfig() {
        return this.otpConfig;
    }

    public BuildConfig buildConfig() {
        return this.buildConfig;
    }

    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    public OtpDataStoreConfig createDataStoreConfig() {
        return new OtpDataStoreConfigAdapter(this.cli.getBaseDirectory(), this.buildConfig().storage);
    }
}

