/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import javax.annotation.Nullable;
import javax.ws.rs.core.Application;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.configure.DataStoreFactory;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.configure.OTPConfiguration;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.standalone.server.OTPApplication;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.logging.MetricsLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTPAppConstruction {
    private static final Logger LOG = LoggerFactory.getLogger(OTPAppConstruction.class);
    private final OTPConfiguration config;
    private OtpDataStore store = null;
    private OTPServer server = null;
    private GraphBuilderDataSources graphBuilderDataSources = null;

    public OTPAppConstruction(CommandLineParameters commandLineParameters) {
        this.config = new OTPConfiguration(commandLineParameters);
        this.initializeOtpFeatures();
    }

    public OtpDataStore store() {
        if (this.store == null) {
            this.store = new DataStoreFactory(this.config.createDataStoreConfig()).open();
        }
        return this.store;
    }

    public GrizzlyServer createGrizzlyServer(Router router) {
        return new GrizzlyServer(this.config.getCli(), this.createApplication(router));
    }

    public void validateConfigAndDataSources() {
        this.graphBuilderDataSources();
    }

    public GraphBuilder createGraphBuilder(Graph baseGraph) {
        LOG.info("Wiring up and configuring graph builder task.");
        return GraphBuilder.create(this.config.buildConfig(), this.graphBuilderDataSources(), baseGraph, this.config.getCli().doLoadStreetGraph(), this.config.getCli().doSaveStreetGraph());
    }

    @Nullable
    public DataSource graphOutputDataSource() {
        return this.graphBuilderDataSources().getOutputGraph();
    }

    public OTPConfiguration config() {
        return this.config;
    }

    public OTPServer server(Router router) {
        if (this.server == null) {
            this.server = new OTPServer(this.config.getCli(), router);
            new MetricsLogging(this.server);
        }
        return this.server;
    }

    public void setOtpConfigVersionsOnServerInfo() {
        OtpProjectInfo.projectInfo().otpConfigVersion = this.config.otpConfig().configVersion;
        OtpProjectInfo.projectInfo().buildConfigVersion = this.config.buildConfig().configVersion;
        OtpProjectInfo.projectInfo().routerConfigVersion = this.config.routerConfig().getConfigVersion();
    }

    private GraphBuilderDataSources graphBuilderDataSources() {
        if (this.graphBuilderDataSources == null) {
            this.graphBuilderDataSources = GraphBuilderDataSources.create(this.config.getCli(), this.config.buildConfig(), this.store());
        }
        return this.graphBuilderDataSources;
    }

    private void initializeOtpFeatures() {
        OTPFeature.enableFeatures(this.config.otpConfig().otpFeatures);
        OTPFeature.logFeatureSetup();
    }

    private Application createApplication(Router router) {
        return new OTPApplication(this.server(router));
    }
}

