/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.updaters.sources;

import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.standalone.config.NodeAdapter;
import org.opentripplanner.updater.DataSourceType;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.VehicleRentalDataSourceParameters;
import org.opentripplanner.util.OtpAppException;

public class VehicleRentalSourceFactory {
    private static final Map<String, DataSourceType> CONFIG_MAPPING = new HashMap<String, DataSourceType>();
    private final DataSourceType type;
    private final NodeAdapter c;

    public VehicleRentalSourceFactory(DataSourceType type, NodeAdapter c) {
        this.type = type;
        this.c = c;
    }

    public static VehicleRentalDataSourceParameters create(String typeKey, NodeAdapter c) {
        DataSourceType type = CONFIG_MAPPING.get(typeKey);
        if (type == null) {
            throw new OtpAppException("The updater source type is unknown: " + typeKey);
        }
        return new VehicleRentalSourceFactory(type, c).create();
    }

    public VehicleRentalDataSourceParameters create() {
        switch (this.type) {
            case GBFS: {
                return new GbfsVehicleRentalDataSourceParameters(this.url(), this.language(), this.allowKeepingRentedVehicleAtDestination(), this.headers());
            }
            case SMOOVE: {
                return new SmooveBikeRentalDataSourceParameters(this.url(), this.network(), this.allowOverloading(), this.headers());
            }
        }
        return new VehicleRentalDataSourceParameters(this.type, this.url(), this.headers());
    }

    private String language() {
        return this.c.asText("language", null);
    }

    private Map<String, String> headers() {
        return this.c.asMap("headers", NodeAdapter::asText);
    }

    private String url() {
        return this.c.asText("url");
    }

    private String network() {
        return this.c.asText("network", null);
    }

    private boolean allowKeepingRentedVehicleAtDestination() {
        return this.c.asBoolean("allowKeepingRentedBicycleAtDestination", false);
    }

    private boolean allowOverloading() {
        return this.c.asBoolean("allowOverloading", false);
    }

    static {
        CONFIG_MAPPING.put("gbfs", DataSourceType.GBFS);
        CONFIG_MAPPING.put("smoove", DataSourceType.SMOOVE);
    }
}

